/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.panels.search.AnySelectionDirectoryPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchClausePanel;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.panels.search.UserSearchPanel;
import org.apache.syncope.client.console.panels.search.UserSelectionDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;

public class UserSelectionWizardStep
extends WizardStep {
    private static final long serialVersionUID = 36221031226727L;
    private final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    private final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    private final IModel<String> model;
    private final UserSearchPanel userSearchPanel;
    private final UserSelectionDirectoryPanel userDirectoryPanel;

    public UserSelectionWizardStep(IModel<String> title, IModel<String> model, PageReference pageRef) {
        this.setOutputMarkupId(true);
        this.model = model;
        this.setTitleModel(title);
        this.userSearchPanel = (UserSearchPanel)((Object)UserSearchPanel.class.cast(new UserSearchPanel.Builder((IModel<List<SearchClause>>)new ListModel(new ArrayList())).required(false).enableSearch((IEventSink)this).build("usersearch")));
        this.add(new Component[]{this.userSearchPanel});
        AnyTypeTO anyTypeTO = this.anyTypeRestClient.read(AnyTypeKind.USER.name());
        this.userDirectoryPanel = (UserSelectionDirectoryPanel)((Object)UserSelectionDirectoryPanel.class.cast((Object)new UserSelectionDirectoryPanel.Builder(this.anyTypeClassRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).build("searchResult")));
        this.add(new Component[]{this.userDirectoryPanel});
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof SearchClausePanel.SearchEvent) {
            AjaxRequestTarget target = ((SearchClausePanel.SearchEvent)SearchClausePanel.SearchEvent.class.cast(event.getPayload())).getTarget();
            String fiql = SearchUtils.buildFIQL((List)this.userSearchPanel.getModel().getObject(), SyncopeClient.getUserSearchConditionBuilder());
            this.userDirectoryPanel.search(fiql, target);
        } else if (event.getPayload() instanceof AnySelectionDirectoryPanel.ItemSelection) {
            AnySelectionDirectoryPanel.ItemSelection payload = (AnySelectionDirectoryPanel.ItemSelection)event.getPayload();
            UserTO selected = (UserTO)payload.getSelection();
            this.model.setObject((Object)selected.getKey());
            String tableId = ((Component)event.getSource()).get("container:content:searchContainer:resultTable:tablePanel:groupForm:checkgroup:dataTable").getMarkupId();
            String js = "$('#" + tableId + " tr').removeClass('active');";
            js = js + "$('#" + tableId + " td[title=" + selected.getKey() + "]').parent().addClass('active');";
            payload.getTarget().prependJavaScript((CharSequence)js);
        }
    }
}

