/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.TogglePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.PropertyModel;

public abstract class ImplementationEngineTogglePanel
extends TogglePanel<Serializable> {
    private static final long serialVersionUID = -7869528596656778267L;

    public ImplementationEngineTogglePanel(String id, ImplementationTO implementation, final PageReference pageRef) {
        super(id, pageRef);
        final Form form = new Form("implementationEngineForm");
        this.addInnerObject(new Component[]{form});
        final PropertyModel engineModel = new PropertyModel((Object)implementation, "engine");
        form.add(new Component[]{new AjaxDropDownChoicePanel("engine", "Engine", engineModel, false).setNullValid(false).setChoices(Arrays.stream(ImplementationEngine.values()).collect(Collectors.toList())).setStyleSheet("form-control").hideLabel()});
        form.add(new Component[]{new AjaxSubmitLink("changeit", form){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                ImplementationEngineTogglePanel.this.onSubmit((ImplementationEngine)engineModel.getObject(), target);
                target.add(new Component[]{form});
                ImplementationEngineTogglePanel.this.toggle(target, false);
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            protected void onError(AjaxRequestTarget target) {
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }

    protected abstract void onSubmit(ImplementationEngine var1, AjaxRequestTarget var2);

    public void setHeaderLabel(AjaxRequestTarget target) {
        this.setHeader(target, this.getString("engine"));
    }
}

