/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.log.LoggerTO;
import org.apache.syncope.common.lib.types.LoggerLevel;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogsPanel<T extends Serializable>
extends Panel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractLogsPanel.class);
    private static final long serialVersionUID = -6313532280206208227L;
    protected WebMarkupContainer loggerContainer = new WebMarkupContainer("loggerContainer");

    public AbstractLogsPanel(String id, PageReference pageRef, List<LoggerTO> loggerTOs) {
        super(id);
        this.loggerContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.loggerContainer});
        ListViewPanel.Builder<LoggerTO> builder = new ListViewPanel.Builder<LoggerTO>(LoggerTO.class, pageRef){
            private static final long serialVersionUID = 6957788356709885298L;

            @Override
            protected Component getValueComponent(String key, final LoggerTO loggerTO) {
                if ("level".equalsIgnoreCase(key)) {
                    final AjaxDropDownChoicePanel<LoggerLevel> loggerTOs = new AjaxDropDownChoicePanel<LoggerLevel>("field", AbstractLogsPanel.this.getString("level"), (IModel<LoggerLevel>)Model.of((Serializable)loggerTO.getLevel()), false);
                    MetaDataRoleAuthorizationStrategy.authorize(loggerTOs, (Action)Component.ENABLE, (String)"LOG_SET_LEVEL");
                    loggerTOs.hideLabel();
                    loggerTOs.setChoices(Arrays.asList(LoggerLevel.values()));
                    loggerTOs.setNullValid(false);
                    loggerTOs.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                        private static final long serialVersionUID = -1107858522700306810L;

                        protected void onUpdate(AjaxRequestTarget target) {
                            try {
                                loggerTO.setLevel((LoggerLevel)loggerTOs.getModelObject());
                                AbstractLogsPanel.this.update(loggerTO);
                                SyncopeConsoleSession.get().success((Serializable)((Object)AbstractLogsPanel.this.getString("operation_succeeded")));
                                target.add(new Component[]{loggerTOs});
                            }
                            catch (SyncopeClientException e) {
                                LOG.error("Error updating the logger level", (Throwable)e);
                                SyncopeConsoleSession.get().onException((Exception)((Object)e));
                            }
                            ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                        }
                    }});
                    return loggerTOs;
                }
                return super.getValueComponent(key, loggerTO);
            }
        };
        builder.setItems(loggerTOs).setModel((IModel<Collection<LoggerTO>>)new ListModel(loggerTOs)).includes("key", "level").withChecks(ListViewPanel.CheckAvailability.NONE).setReuseItem(false);
        this.loggerContainer.add(new Component[]{builder.build("logger")});
    }

    protected abstract void update(LoggerTO var1);
}

