/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.wicket.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AbstractAttrs;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.UserWrapper;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class VirAttrs
extends AbstractAttrs<VirSchemaTO> {
    private static final long serialVersionUID = -7982691107029848579L;
    private final AjaxWizard.Mode mode;
    private final AnyWrapper<?> modelObject;

    public <T extends AnyTO> VirAttrs(AnyWrapper<T> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichVirAttrs) {
        super(modelObject, mode, anyTypeClasses, whichVirAttrs);
        this.mode = mode;
        this.modelObject = modelObject;
        this.setTitleModel((IModel)new ResourceModel("attributes.virtual"));
        this.add(new Component[]{new Accordion("virSchemas", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Virtual Attributes")){
            private static final long serialVersionUID = 1037272333056449378L;

            public WebMarkupContainer getPanel(String panelId) {
                return new VirSchemas(panelId, VirAttrs.this.schemas, (IModel<List<AttrTO>>)VirAttrs.this.attrTOs);
            }
        }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
        this.add(new Component[]{new ListView<MembershipTO>("membershipsVirSchemas", this.memberships){
            private static final long serialVersionUID = 9101744072914090143L;

            protected void populateItem(ListItem<MembershipTO> item) {
                final MembershipTO membershipTO = (MembershipTO)item.getModelObject();
                item.add(new Component[]{new Accordion("membershipVirSchemas", Collections.singletonList(new AbstractTab((IModel)new StringResourceModel("attributes.membership.accordion", (Component)VirAttrs.this, (IModel)Model.of((Serializable)membershipTO))){
                    private static final long serialVersionUID = 1037272333056449378L;

                    public WebMarkupContainer getPanel(String panelId) {
                        return new VirSchemas(panelId, (Map)VirAttrs.this.membershipSchemas.get(membershipTO.getGroupKey()), (IModel<List<AttrTO>>)new ListModel(VirAttrs.this.getAttrsFromTO(membershipTO)));
                    }
                }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(-1))).setOutputMarkupId(true)});
            }
        }});
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.VIRTUAL;
    }

    @Override
    protected List<AttrTO> getAttrsFromTO() {
        return this.anyTO.getVirAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected List<AttrTO> getAttrsFromTO(MembershipTO membershipTO) {
        return membershipTO.getVirAttrs().stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    @Override
    protected void setAttrs() {
        ArrayList attrs = new ArrayList();
        Map attrMap = EntityTOUtils.buildAttrMap((Collection)this.anyTO.getVirAttrs());
        attrs.addAll(this.schemas.values().stream().map(schema -> {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.containsKey(schema.getKey())) {
                attrTO.getValues().addAll(((AttrTO)attrMap.get(schema.getKey())).getValues());
            } else {
                attrTO.getValues().add("");
            }
            return attrTO;
        }).collect(Collectors.toList()));
        this.anyTO.getVirAttrs().clear();
        this.anyTO.getVirAttrs().addAll(attrs);
    }

    @Override
    protected void setAttrs(MembershipTO membershipTO) {
        ArrayList attrs = new ArrayList();
        Map attrMap = ((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).isPresent() ? EntityTOUtils.buildAttrMap((Collection)((MembershipTO)((GroupableRelatableTO)GroupableRelatableTO.class.cast(this.anyTO)).getMembership(membershipTO.getGroupKey()).get()).getVirAttrs()) : new HashMap();
        attrs.addAll(((Map)this.membershipSchemas.get(membershipTO.getGroupKey())).values().stream().map(schema -> {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.containsKey(schema.getKey())) {
                attrTO.getValues().addAll(((AttrTO)attrMap.get(schema.getKey())).getValues());
            } else {
                attrTO.getValues().add("");
            }
            return attrTO;
        }).collect(Collectors.toList()));
        membershipTO.getVirAttrs().clear();
        membershipTO.getVirAttrs().addAll(attrs);
    }

    public class VirSchemas
    extends AbstractAttrsWizardStep.Schemas {
        private static final long serialVersionUID = -4730563859116024676L;

        public VirSchemas(String id, final Map<String, VirSchemaTO> schemas, IModel<List<AttrTO>> attrTOs) {
            super(id);
            this.add(new Component[]{new ListView<AttrTO>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<AttrTO> item) {
                    AttrTO attrTO = (AttrTO)item.getModelObject();
                    VirSchemaTO virSchemaTO = (VirSchemaTO)schemas.get(attrTO.getSchema());
                    AbstractFieldPanel panel = new AjaxTextFieldPanel("panel", virSchemaTO.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<String>)new Model(), false);
                    if (VirAttrs.this.mode == AjaxWizard.Mode.TEMPLATE) {
                        ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast((Object)panel)).enableJexlHelp().setEnabled(!virSchemaTO.isReadonly());
                    } else {
                        panel = new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build("panel", virSchemaTO.getLabel(SyncopeConsoleSession.get().getLocale()), (FieldPanel)AjaxTextFieldPanel.class.cast((Object)panel));
                        panel.setEnabled(!virSchemaTO.isReadonly());
                    }
                    item.add(new Component[]{panel});
                    if (!attrTO.getValues().isEmpty() && VirAttrs.this.modelObject instanceof UserWrapper && ((UserWrapper)UserWrapper.class.cast(VirAttrs.this.modelObject)).getPreviousUserTO() != null) {
                        panel.showExternAction((Component)new LabelInfo("externalAction", ""));
                    }
                }
            }});
        }
    }
}

