/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public final class UserFormFinalizerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(UserFormFinalizerUtils.class);
    private static UserFormFinalizerUtils INSTANCE;
    private final ClassPathScanImplementationLookup classPathScanImplementationLookup = (ClassPathScanImplementationLookup)SyncopeConsoleApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserFormFinalizerUtils getInstance() {
        Logger logger = LOG;
        synchronized (logger) {
            if (INSTANCE == null) {
                INSTANCE = new UserFormFinalizerUtils();
            }
        }
        return INSTANCE;
    }

    private UserFormFinalizerUtils() {
    }

    public List<UserFormFinalizer> getFormFinalizers(AjaxWizard.Mode mode) {
        ArrayList<UserFormFinalizer> finalizers = new ArrayList<UserFormFinalizer>();
        this.classPathScanImplementationLookup.getUserFormFinalizerClasses(mode).forEach(applier -> {
            if (applier != null) {
                try {
                    finalizers.add((UserFormFinalizer)ClassUtils.getConstructorIfAvailable((Class)applier, (Class[])new Class[0]).newInstance(new Object[0]));
                }
                catch (Exception e) {
                    LOG.error("Could not instantiate {}", applier, (Object)e);
                }
            }
        });
        return finalizers;
    }
}

