/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.commons.LinkedAccountPlainAttrProperty;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.tabs.Accordion;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.console.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tabs.AbstractTab;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class LinkedAccountPlainAttrsPanel
extends AbstractAttrsWizardStep<PlainSchemaTO> {
    private static final long serialVersionUID = -6664931684253730934L;
    private final LinkedAccountTO linkedAccountTO;
    private final UserTO userTO;
    private final Set<AttrTO> fixedAttrs = new HashSet<AttrTO>();
    private final List<LinkedAccountPlainAttrProperty> accountPlainAttrProperties = new ArrayList<LinkedAccountPlainAttrProperty>();

    public <T extends AnyTO> LinkedAccountPlainAttrsPanel(EntityWrapper<LinkedAccountTO> modelObject, UserTO userTO, List<String> whichPlainAttrs) throws IllegalArgumentException {
        super((AnyTO)userTO, AjaxWizard.Mode.EDIT, new AnyTypeRestClient().read(userTO.getType()).getClasses(), whichPlainAttrs, modelObject);
        this.linkedAccountTO = modelObject.getInnerObject();
        this.fixedAttrs.addAll(this.linkedAccountTO.getPlainAttrs().stream().filter(attrTO -> this.checkIsReadonlyAttr(attrTO.getSchema())).collect(Collectors.toList()));
        this.userTO = userTO;
        this.add(new Component[]{new Accordion("plainSchemas", Collections.singletonList(new AbstractTab((IModel)new ResourceModel("attributes.accordion", "Plain Attributes")){
            private static final long serialVersionUID = -7078941093668723016L;

            public WebMarkupContainer getPanel(String panelId) {
                return new PlainSchemasOwn(panelId, (Map<String, PlainSchemaTO>)LinkedAccountPlainAttrsPanel.this.schemas, (IModel<List<AttrTO>>)LinkedAccountPlainAttrsPanel.this.attrTOs);
            }
        }), (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0))).setOutputMarkupId(true)});
    }

    @Override
    protected FormComponent<?> checkboxToggle(AttrTO attrTO, final AbstractFieldPanel<?> panel, final boolean isMultivalue) {
        final LinkedAccountPlainAttrProperty property = this.accountPlainAttrProperties.stream().filter(existingProperty -> existingProperty.getSchema().equals(attrTO.getSchema())).findFirst().orElseGet(() -> {
            LinkedAccountPlainAttrProperty newProperty = new LinkedAccountPlainAttrProperty();
            newProperty.setOverridable(this.linkedAccountTO.getPlainAttr(attrTO.getSchema()).isPresent());
            newProperty.setSchema(attrTO.getSchema());
            newProperty.getValues().addAll(attrTO.getValues());
            this.accountPlainAttrProperties.add(newProperty);
            return newProperty;
        });
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.success).withOffStyle(BootstrapToggleConfig.Style.danger).withSize(BootstrapToggleConfig.Size.mini);
        return new BootstrapToggle("externalAction", (IModel)new PropertyModel((Object)property, "overridable"), config){
            private static final long serialVersionUID = -875219845189261873L;

            protected CheckBox newCheckBox(String id, final IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        if (isMultivalue) {
                            ((MultiFieldPanel)((Object)MultiFieldPanel.class.cast((Object)panel))).setFormReadOnly((Boolean)model.getObject() == false);
                        } else {
                            ((FieldPanel)FieldPanel.class.cast((Object)panel)).setReadOnly((Boolean)model.getObject() == false);
                        }
                        LinkedAccountPlainAttrsPanel.this.updateAccountPlainSchemas(property, (Boolean)model.getObject());
                        target.add(new Component[]{panel});
                    }
                }});
                return checkBox;
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"Override"));
            }

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"Override?"));
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)"overridable", " ");
            }
        };
    }

    private void updateAccountPlainSchemas(LinkedAccountPlainAttrProperty property, Boolean modelObject) {
        HashSet withoutCurrentSchema = new HashSet(this.linkedAccountTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getSchema().equals(property.getSchema()) && this.checkIsReadonlyAttr(attrTO.getSchema())).collect(Collectors.toSet()));
        this.linkedAccountTO.getPlainAttrs().clear();
        this.linkedAccountTO.getPlainAttrs().addAll(withoutCurrentSchema);
        if (modelObject.booleanValue()) {
            this.linkedAccountTO.getPlainAttrs().add(this.fixedAttrs.stream().filter(attrTO -> attrTO.getSchema().equals(property.getSchema())).findFirst().orElseGet(() -> new AttrTO.Builder().schema(property.getSchema()).values(property.getValues()).build()));
        }
    }

    @Override
    protected SchemaType getSchemaType() {
        return SchemaType.PLAIN;
    }

    @Override
    protected void setAttrs() {
        ArrayList attrs = new ArrayList();
        List<PlainSchemaTO> notReadonlyValues = this.schemas.values().stream().filter(schema -> this.checkIsReadonlyAttr(schema.getKey())).collect(Collectors.toList());
        this.setFixedAttr(notReadonlyValues);
        Map attrMap = EntityTOUtils.buildAttrMap(this.fixedAttrs);
        attrs.addAll(notReadonlyValues.stream().map(schema -> {
            AttrTO attrTO = new AttrTO();
            attrTO.setSchema(schema.getKey());
            if (attrMap.get(schema.getKey()) == null || ((AttrTO)attrMap.get(schema.getKey())).getValues().isEmpty()) {
                attrTO.getValues().add("");
            } else {
                attrTO = (AttrTO)attrMap.get(schema.getKey());
            }
            return attrTO;
        }).collect(Collectors.toList()));
        this.fixedAttrs.clear();
        this.fixedAttrs.addAll(attrs);
    }

    @Override
    protected List<AttrTO> getAttrsFromTO() {
        return this.fixedAttrs.stream().sorted(this.attrComparator).collect(Collectors.toList());
    }

    private void setFixedAttr(Collection<PlainSchemaTO> values) {
        values.forEach(schema -> {
            if (this.linkedAccountTO.getPlainAttr(schema.getKey()).isPresent()) {
                this.fixedAttrs.add((AttrTO)this.linkedAccountTO.getPlainAttr(schema.getKey()).get());
            } else if (this.userTO.getPlainAttr(schema.getKey()).isPresent()) {
                this.fixedAttrs.add((AttrTO)this.userTO.getPlainAttr(schema.getKey()).get());
            }
        });
    }

    private boolean checkIsReadonlyAttr(String schema) {
        return this.schemas.isEmpty() ? true : !((PlainSchemaTO)this.schemas.get(schema)).isReadonly();
    }

    private class PlainSchemasOwn
    extends AbstractAttrsWizardStep.PlainSchemas<List<AttrTO>> {
        private static final long serialVersionUID = -4730563859116024676L;

        PlainSchemasOwn(String id, final Map<String, PlainSchemaTO> schemas, IModel<List<AttrTO>> attrTOs) {
            super(id, schemas, attrTOs);
            this.add(new Component[]{new ListView<AttrTO>("schemas", attrTOs){
                private static final long serialVersionUID = 9101744072914090143L;

                protected void populateItem(ListItem<AttrTO> item) {
                    AttrTO attrTO = (AttrTO)item.getModelObject();
                    boolean isMultivalue = ((PlainSchemaTO)schemas.get(attrTO.getSchema())).isMultivalue();
                    AbstractFieldPanel<?> panel = PlainSchemasOwn.this.setPanel(schemas, item, !LinkedAccountPlainAttrsPanel.this.linkedAccountTO.getPlainAttr(attrTO.getSchema()).isPresent());
                    panel.showExternAction((Component)LinkedAccountPlainAttrsPanel.this.checkboxToggle(attrTO, panel, isMultivalue));
                }
            }});
        }
    }
}

