/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.pages.Realms;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wizards.any.AnnotatedBeanPanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.to.AbstractAnnotatedBean;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Details<T extends AnyTO>
extends WizardStep {
    private static final long serialVersionUID = -8995647450549098844L;
    protected static final Logger LOG = LoggerFactory.getLogger(Details.class);
    private final RealmRestClient realmRestClient = new RealmRestClient();
    protected final PageReference pageRef;
    private final FieldPanel<String> realm;

    public Details(AnyWrapper<T> wrapper, boolean templateMode, boolean includeStatusPanel, final PageReference pageRef) {
        Fragment fragment;
        this.pageRef = pageRef;
        final List<String> authRealms = SyncopeConsoleSession.get().getAuthRealms();
        T inner = wrapper.getInnerObject();
        if (templateMode) {
            this.realm = new AjaxTextFieldPanel("destinationRealm", "destinationRealm", (IModel<String>)new PropertyModel(inner, "realm"), false);
            ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(this.realm)).enableJexlHelp();
            fragment = new Fragment("realmsFragment", "realmsTemplateFragment", (MarkupContainer)this);
        } else {
            final boolean isSearchEnabled = RealmsUtils.isSearchEnabled();
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(!isSearchEnabled);
            settings.setShowListOnEmptyInput(!isSearchEnabled);
            this.realm = new AjaxSearchFieldPanel("destinationRealm", "destinationRealm", (IModel)new PropertyModel(inner, "realm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                @Override
                protected Iterator<String> getChoices(String input) {
                    return (isSearchEnabled ? Details.this.realmRestClient.search(RealmsUtils.buildQuery(input)).getResult() : (pageRef.getPage() instanceof Realms ? Details.this.getRealmsFromLinks(((Realms)((Object)Realms.class.cast(pageRef.getPage()))).getRealmChoicePanel().getLinks()) : Details.this.realmRestClient.list("/"))).stream().filter(realm -> authRealms.stream().anyMatch(authRealm -> realm.getFullPath().startsWith((String)authRealm))).map(item -> item.getFullPath()).collect(Collectors.toList()).iterator();
                }
            };
            fragment = new Fragment("realmsFragment", "realmsSearchFragment", (MarkupContainer)this);
        }
        fragment.addOrReplace(new Component[]{this.realm});
        this.addOrReplace(new Component[]{fragment});
        this.add(new Component[]{this.getGeneralStatusInformation("generalStatusInformation", inner).setEnabled(includeStatusPanel).setVisible(includeStatusPanel).setRenderBodyOnly(true)});
    }

    public Details<T> disableRealmSpecification() {
        this.realm.setReadOnly(true);
        return this;
    }

    protected AnnotatedBeanPanel getGeneralStatusInformation(String id, T anyTO) {
        return new AnnotatedBeanPanel(id, (AbstractAnnotatedBean)anyTO);
    }

    private List<RealmTO> getRealmsFromLinks(List<AbstractLink> realmLinks) {
        ArrayList<RealmTO> realms = new ArrayList<RealmTO>();
        realmLinks.stream().map(Component::getDefaultModelObject).filter(modelObject -> modelObject instanceof RealmTO).forEachOrdered(modelObject -> realms.add((RealmTO)modelObject));
        return realms;
    }
}

