/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.SchemaUtils;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.ajax.markup.html.LabelInfo;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDateTimeFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSpinnerFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.BinaryFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.EncryptedFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public abstract class AbstractAttrsWizardStep<S extends SchemaTO>
extends WizardStep
implements WizardModel.ICondition {
    private static final long serialVersionUID = 8931397230194043674L;
    protected final Comparator<AttrTO> attrComparator = new AttrComparator();
    private final SchemaRestClient schemaRestClient = new SchemaRestClient();
    protected final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    protected final AnyTO anyTO;
    protected AnyTO previousObject;
    private final List<String> whichAttrs;
    protected final Map<String, S> schemas = new LinkedHashMap<String, S>();
    protected final IModel<List<AttrTO>> attrTOs;
    private final List<String> anyTypeClasses;
    protected String fileKey = "";
    protected final AjaxWizard.Mode mode;

    public AbstractAttrsWizardStep(AnyTO anyTO, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichAttrs, EntityWrapper<?> modelObject) {
        this.anyTypeClasses = anyTypeClasses;
        this.attrTOs = new ListModel(Collections.emptyList());
        this.setOutputMarkupId(true);
        this.mode = mode;
        this.anyTO = anyTO;
        this.whichAttrs = whichAttrs;
    }

    protected List<AttrTO> loadAttrTOs() {
        ArrayList<String> classes = new ArrayList<String>(this.anyTypeClasses);
        classes.addAll(this.anyTypeClassRestClient.list(this.anyTO.getAuxClasses()).stream().map(EntityTO::getKey).collect(Collectors.toList()));
        this.setSchemas(classes);
        this.setAttrs();
        return this.getAttrsFromTO();
    }

    protected boolean reoderSchemas() {
        return !this.whichAttrs.isEmpty();
    }

    protected abstract SchemaType getSchemaType();

    private void setSchemas(List<String> anyTypeClasses) {
        this.setSchemas(anyTypeClasses, this.schemas);
    }

    protected void setSchemas(List<String> anyTypeClasses, Map<String, S> scs) {
        List<SchemaTO> allSchemas = anyTypeClasses.isEmpty() ? Collections.emptyList() : this.schemaRestClient.getSchemas(this.getSchemaType(), null, anyTypeClasses.toArray(new String[0]));
        scs.clear();
        if (this.reoderSchemas()) {
            allSchemas.removeAll(allSchemas.stream().filter(schemaTO -> !this.whichAttrs.contains(schemaTO.getKey())).collect(Collectors.toSet()));
        }
        allSchemas.forEach(schemaTO -> scs.put(schemaTO.getKey(), schemaTO));
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (CollectionUtils.isEmpty((Collection)((Collection)this.attrTOs.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    protected abstract void setAttrs();

    protected abstract List<AttrTO> getAttrsFromTO();

    public boolean evaluate() {
        this.attrTOs.setObject(this.loadAttrTOs());
        return !((List)this.attrTOs.getObject()).isEmpty();
    }

    public PageReference getPageReference() {
        return null;
    }

    protected FieldPanel getFieldPanel(final PlainSchemaTO plainSchema) {
        FieldPanel panel;
        boolean jexlHelp;
        AttrSchemaType type;
        boolean readOnly;
        boolean required;
        if (this.mode == AjaxWizard.Mode.TEMPLATE) {
            required = false;
            readOnly = false;
            type = AttrSchemaType.String;
            jexlHelp = true;
        } else {
            required = plainSchema.getMandatoryCondition().equalsIgnoreCase("true");
            readOnly = plainSchema.isReadonly();
            type = plainSchema.getType();
            jexlHelp = false;
        }
        switch (type) {
            case Boolean: {
                panel = new AjaxCheckBoxPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<Boolean>)new Model(), true);
                panel.setRequired(required);
                break;
            }
            case Date: {
                String datePattern = plainSchema.getConversionPattern() == null ? "yyyy-MM-dd'T'HH:mm:ssZ" : plainSchema.getConversionPattern();
                panel = datePattern.contains("H") ? new AjaxDateTimeFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<Date>)new Model(), datePattern) : new AjaxDateFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<Date>)new Model(), datePattern);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Enum: {
                panel = new AjaxDropDownChoicePanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), new Model(), true);
                ((AjaxDropDownChoicePanel)panel).setChoices(SchemaUtils.getEnumeratedValues(plainSchema));
                if (StringUtils.isNotBlank((CharSequence)plainSchema.getEnumerationKeys())) {
                    ((AjaxDropDownChoicePanel)panel).setChoiceRenderer(new IChoiceRenderer<String>(){
                        private static final long serialVersionUID = -3724971416312135885L;
                        private final Map<String, String> valueMap;
                        {
                            this.valueMap = SchemaUtils.getEnumeratedKeyValues(plainSchema);
                        }

                        public String getDisplayValue(String value) {
                            return this.valueMap.get(value) == null ? value : this.valueMap.get(value);
                        }

                        public String getIdValue(String value, int i) {
                            return value;
                        }

                        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
                            return id;
                        }
                    });
                }
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Long: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().build("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), Long.class, (IModel<Long>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Double: {
                panel = new AjaxSpinnerFieldPanel.Builder().enableOnChange().step(0.1).build("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), Double.class, (IModel<Double>)new Model());
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Binary: {
                final PageReference pageRef = this.getPageReference();
                panel = new BinaryFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel)new Model(), plainSchema.getMimeType(), this.fileKey){
                    private static final long serialVersionUID = -3268213909514986831L;

                    @Override
                    protected PageReference getPageReference() {
                        return pageRef;
                    }
                };
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            case Encrypted: {
                FieldPanel fieldPanel = panel = "ENCRYPTED_DECODE_CONVERSION_PATTERN".equals(plainSchema.getConversionPattern()) ? new AjaxTextFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<String>)new Model(), true) : new EncryptedFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<String>)new Model(), true);
                if (!required) break;
                panel.addRequiredLabel();
                break;
            }
            default: {
                panel = new AjaxTextFieldPanel("panel", plainSchema.getLabel(SyncopeConsoleSession.get().getLocale()), (IModel<String>)new Model(), true);
                if (jexlHelp) {
                    ((AjaxTextFieldPanel)AjaxTextFieldPanel.class.cast(panel)).enableJexlHelp();
                }
                if (!required) break;
                panel.addRequiredLabel();
            }
        }
        panel.setReadOnly(readOnly);
        return panel;
    }

    protected FormComponent<?> checkboxToggle(AttrTO attrTO, AbstractFieldPanel<?> panel, boolean isMultivalue) {
        return null;
    }

    protected abstract class PlainSchemas<T>
    extends Schemas {
        private static final long serialVersionUID = 8315035592714180404L;

        public PlainSchemas(String id, Map<String, PlainSchemaTO> schemas, IModel<T> attrTOs) {
            super(id);
        }

        protected AbstractFieldPanel<?> setPanel(Map<String, PlainSchemaTO> schemas, ListItem<AttrTO> item, boolean setReadOnly) {
            AttrTO attrTO = (AttrTO)item.getModelObject();
            boolean isMultivalue = AbstractAttrsWizardStep.this.mode != AjaxWizard.Mode.TEMPLATE && schemas.get(attrTO.getSchema()).isMultivalue();
            AbstractFieldPanel panel = AbstractAttrsWizardStep.this.getFieldPanel(schemas.get(attrTO.getSchema()));
            if (isMultivalue) {
                panel = new MultiFieldPanel.Builder(new PropertyModel((Object)attrTO, "values")).build("panel", attrTO.getSchema(), (FieldPanel)FieldPanel.class.cast((Object)panel)).setFormAsMultipart(true);
                ((MultiFieldPanel)((Object)MultiFieldPanel.class.cast((Object)panel))).setReadOnly(schemas.get(attrTO.getSchema()).isReadonly());
                ((MultiFieldPanel)((Object)MultiFieldPanel.class.cast((Object)panel))).setFormReadOnly(setReadOnly);
            } else {
                ((FieldPanel)FieldPanel.class.cast((Object)panel)).setNewModel(attrTO.getValues()).setReadOnly(setReadOnly);
            }
            item.add(new Component[]{panel});
            this.setExternalAction(attrTO, panel);
            return panel;
        }

        protected void setExternalAction(AttrTO attrTO, AbstractFieldPanel<?> panel) {
            Optional prevAttr;
            Optional optional = prevAttr = AbstractAttrsWizardStep.this.previousObject == null ? Optional.empty() : AbstractAttrsWizardStep.this.previousObject.getPlainAttr(attrTO.getSchema());
            if (AbstractAttrsWizardStep.this.previousObject != null && (!prevAttr.isPresent() && attrTO.getValues().stream().anyMatch(StringUtils::isNotBlank) || prevAttr.isPresent() && !ListUtils.isEqualList((Collection)((AttrTO)prevAttr.get()).getValues().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList()), (Collection)attrTO.getValues().stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())))) {
                List oldValues = prevAttr.isPresent() ? ((AttrTO)prevAttr.get()).getValues() : Collections.emptyList();
                panel.showExternAction((Component)new LabelInfo("externalAction", oldValues));
            }
        }
    }

    public class Schemas
    extends Panel {
        private static final long serialVersionUID = -2447602429647965090L;

        public Schemas(String id) {
            super(id);
        }
    }

    private class AttrComparator
    implements Comparator<AttrTO>,
    Serializable {
        private static final long serialVersionUID = -5105030477767941060L;

        private AttrComparator() {
        }

        @Override
        public int compare(AttrTO left, AttrTO right) {
            if (left == null || StringUtils.isEmpty((CharSequence)left.getSchema())) {
                return -1;
            }
            if (right == null || StringUtils.isEmpty((CharSequence)right.getSchema())) {
                return 1;
            }
            if (AbstractAttrsWizardStep.this.reoderSchemas()) {
                int rightIndex;
                int leftIndex = AbstractAttrsWizardStep.this.whichAttrs.indexOf(left.getSchema());
                if (leftIndex > (rightIndex = AbstractAttrsWizardStep.this.whichAttrs.indexOf(right.getSchema()))) {
                    return 1;
                }
                if (leftIndex < rightIndex) {
                    return -1;
                }
                return 0;
            }
            return left.getSchema().compareTo(right.getSchema());
        }
    }
}

