/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.any.AbstractAttrsWizardStep;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.DerAttrs;
import org.apache.syncope.client.console.wizards.any.PlainAttrs;
import org.apache.syncope.client.console.wizards.any.VirAttrs;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAttrs<S extends SchemaTO>
extends AbstractAttrsWizardStep<S> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAttrs.class);
    private static final long serialVersionUID = -5387344116983102292L;
    private final GroupRestClient groupRestClient = new GroupRestClient();
    protected final IModel<List<MembershipTO>> memberships;
    protected final Map<String, Map<String, S>> membershipSchemas = new LinkedHashMap<String, Map<String, S>>();

    public AbstractAttrs(AnyWrapper<?> modelObject, AjaxWizard.Mode mode, List<String> anyTypeClasses, List<String> whichAttrs) {
        super((AnyTO)modelObject.getInnerObject(), mode, anyTypeClasses, whichAttrs, null);
        this.memberships = new ListModel(Collections.emptyList());
        this.setOutputMarkupId(true);
    }

    private List<MembershipTO> loadMemberships() {
        this.membershipSchemas.clear();
        ArrayList<MembershipTO> membs = new ArrayList<MembershipTO>();
        try {
            ((List)PropertyResolver.getPropertyField((String)"memberships", (Object)this.anyTO).get(this.anyTO)).forEach(memb -> {
                this.setSchemas(memb.getGroupKey(), this.anyTypeClassRestClient.list(this.getMembershipAuxClasses((MembershipTO)memb, this.anyTO.getType())).stream().map(EntityTO::getKey).collect(Collectors.toList()));
                this.setAttrs((MembershipTO)memb);
                if (this instanceof PlainAttrs && !memb.getPlainAttrs().isEmpty()) {
                    membs.add((MembershipTO)memb);
                } else if (this instanceof DerAttrs && !memb.getDerAttrs().isEmpty()) {
                    membs.add((MembershipTO)memb);
                } else if (this instanceof VirAttrs && !memb.getVirAttrs().isEmpty()) {
                    membs.add((MembershipTO)memb);
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | WicketRuntimeException throwable) {
            // empty catch block
        }
        return membs;
    }

    private void setSchemas(String membership, List<String> anyTypeClasses) {
        Map<Object, Object> mscs;
        if (this.membershipSchemas.containsKey(membership)) {
            mscs = this.membershipSchemas.get(membership);
        } else {
            mscs = new LinkedHashMap();
            this.membershipSchemas.put(membership, mscs);
        }
        this.setSchemas(anyTypeClasses, mscs);
    }

    private List<String> getMembershipAuxClasses(MembershipTO membershipTO, String anyType) {
        try {
            GroupTO groupTO = (GroupTO)this.groupRestClient.read(membershipTO.getGroupKey());
            Optional typeExtension = groupTO.getTypeExtension(anyType);
            if (!typeExtension.isPresent()) {
                LOG.trace("Unable to locate type extension for " + anyType);
                return Collections.emptyList();
            }
            return ((TypeExtensionTO)typeExtension.get()).getAuxClasses();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    protected abstract void setAttrs(MembershipTO var1);

    protected abstract List<AttrTO> getAttrsFromTO(MembershipTO var1);

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        if (CollectionUtils.isEmpty((Collection)((Collection)this.attrTOs.getObject())) && CollectionUtils.isEmpty((Collection)((Collection)this.memberships.getObject()))) {
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("$('#emptyPlaceholder').append(\"%s\"); $('#attributes').hide();", this.getString("attribute.empty.list"))));
        }
    }

    @Override
    public boolean evaluate() {
        this.attrTOs.setObject(this.loadAttrTOs());
        this.memberships.setObject(this.loadMemberships());
        return !((List)this.attrTOs.getObject()).isEmpty() || !((List)this.memberships.getObject()).isEmpty();
    }
}

