/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.syncope.client.console.commons.Constants;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MappingPurposePanel;
import org.apache.syncope.client.console.widgets.ItemTransformerWidget;
import org.apache.syncope.client.console.widgets.JEXLTransformerWidget;
import org.apache.syncope.client.console.wizards.resources.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.JEXLTransformersTogglePanel;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public abstract class AbstractMappingPanel
extends Panel {
    private static final long serialVersionUID = -8295587900937040104L;
    protected final AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    protected final AnyTypeClassRestClient anyTypeClassRestClient = new AnyTypeClassRestClient();
    protected final Label passwordLabel;
    protected final Label purposeLabel;
    protected final AjaxButton addMappingBtn;
    protected final ListView<ItemTO> mappings;
    protected final WebMarkupContainer mappingContainer;

    public AbstractMappingPanel(String id, final ItemTransformersTogglePanel itemTransformers, final JEXLTransformersTogglePanel jexlTransformers, final IModel<List<ItemTO>> model, boolean addMappingBtnVisible, final boolean hidePurpose, final MappingPurpose defaultPurpose) {
        super(id);
        this.setOutputMarkupId(true);
        this.mappingContainer = new WebMarkupContainer("mappingContainer");
        this.mappingContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.mappingContainer});
        this.passwordLabel = new Label("passwordLabel", (IModel)new ResourceModel("password"));
        this.mappingContainer.add(new Component[]{this.passwordLabel});
        this.purposeLabel = new Label("purposeLabel", (IModel)new ResourceModel("purpose"));
        this.mappingContainer.add(new Component[]{this.purposeLabel});
        this.mappingContainer.add(new Component[]{new Label("intAttrNameInfo", (IModel)Model.of()).add(new Behavior[]{new PopoverBehavior((IModel)Model.of(), (IModel)Model.of((Serializable)((Object)(this.getString("intAttrNameInfo.help") + "<code>groups[groupName].attribute</code>, <code>users[userName].attribute</code>, <code>anyObjects[anyObjectName].attribute</code>, <code>relationships[relationshipType][anyType].attribute</code> or <code>memberships[groupName].attribute</code> or <code>privileges[applicationKey]</code>"))), new PopoverConfig().withHtml(true).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.right)){
            private static final long serialVersionUID = -7867802555691605021L;

            protected String createRelAttribute() {
                return "intAttrNameInfo";
            }
        }})});
        this.mappingContainer.add(new Component[]{Constants.getJEXLPopover((Component)this, TooltipConfig.Placement.bottom)});
        Collections.sort((List)model.getObject(), (left, right) -> {
            int compared = left == null && right == null ? 0 : (left == null ? 1 : (right == null ? -1 : (left.isConnObjectKey() ? -1 : (right.isConnObjectKey() ? 1 : (left.isPassword() ? -1 : (right.isPassword() ? 1 : (left.getPurpose() == MappingPurpose.BOTH && right.getPurpose() != MappingPurpose.BOTH ? -1 : (left.getPurpose() != MappingPurpose.BOTH && right.getPurpose() == MappingPurpose.BOTH ? 1 : (left.getPurpose() == MappingPurpose.PROPAGATION && (right.getPurpose() == MappingPurpose.PULL || right.getPurpose() == MappingPurpose.NONE) ? -1 : (left.getPurpose() == MappingPurpose.PULL && right.getPurpose() == MappingPurpose.PROPAGATION ? 1 : (left.getPurpose() == MappingPurpose.PULL && right.getPurpose() == MappingPurpose.NONE ? -1 : (left.getPurpose() == MappingPurpose.NONE && right.getPurpose() != MappingPurpose.NONE ? 1 : left.getIntAttrName().compareTo(right.getIntAttrName())))))))))))));
            return compared;
        });
        this.mappings = new ListView<ItemTO>("mappings", model){
            private static final long serialVersionUID = 4949588177564901031L;

            protected void populateItem(final ListItem<ItemTO> item) {
                final ItemTO itemTO = (ItemTO)item.getModelObject();
                if (itemTO.getPurpose() == null) {
                    itemTO.setPurpose(defaultPurpose);
                }
                AjaxTextFieldPanel intAttrName = new AjaxTextFieldPanel("intAttrName", this.getString("intAttrName"), (IModel<String>)new PropertyModel((Object)itemTO, "intAttrName"), false);
                intAttrName.setChoices(Collections.emptyList());
                intAttrName.setRequired(true).hideLabel();
                item.add(new Component[]{intAttrName});
                final AjaxTextFieldPanel extAttrName = new AjaxTextFieldPanel("extAttrName", this.getString("extAttrName"), (IModel<String>)new PropertyModel((Object)itemTO, "extAttrName"));
                extAttrName.setChoices((List)AbstractMappingPanel.this.getExtAttrNames().getObject());
                boolean required = !itemTO.isPassword();
                extAttrName.setRequired(required).hideLabel();
                extAttrName.setEnabled(required);
                item.add(new Component[]{extAttrName});
                item.add(new Component[]{new JEXLTransformerWidget("jexlTransformers", itemTO, jexlTransformers).setRenderBodyOnly(true)});
                item.add(new Component[]{new ItemTransformerWidget("itemTransformers", itemTO, itemTransformers).setRenderBodyOnly(true)});
                final AjaxTextFieldPanel mandatory = new AjaxTextFieldPanel("mandatoryCondition", new ResourceModel("mandatoryCondition", "mandatoryCondition").getObject(), (IModel<String>)new PropertyModel((Object)itemTO, "mandatoryCondition"));
                mandatory.hideLabel();
                mandatory.setChoices(Arrays.asList("true", "false"));
                mandatory.setEnabled(!itemTO.isConnObjectKey());
                item.add(new Component[]{mandatory});
                final AjaxCheckBoxPanel connObjectKey = new AjaxCheckBoxPanel("connObjectKey", new ResourceModel("connObjectKey", "connObjectKey").getObject(), (IModel<Boolean>)new PropertyModel((Object)itemTO, "connObjectKey"), false);
                connObjectKey.hideLabel();
                item.add(new Component[]{connObjectKey});
                final AjaxCheckBoxPanel password = new AjaxCheckBoxPanel("password", new ResourceModel("password", "password").getObject(), (IModel<Boolean>)new PropertyModel((Object)itemTO, "password"), false);
                item.add(new Component[]{password.hideLabel()});
                WebMarkupContainer purpose = new WebMarkupContainer("purpose");
                purpose.setOutputMarkupId(true);
                MappingPurposePanel purposeActions = new MappingPurposePanel("purposeActions", (IModel<MappingPurpose>)new PropertyModel((Object)itemTO, "purpose"), purpose);
                purpose.add(new Component[]{purposeActions.setRenderBodyOnly(true)});
                item.add(new Component[]{purpose});
                ActionsPanel<Serializable> actions = new ActionsPanel<Serializable>("toRemove", null);
                actions.add(new ActionLink<Serializable>(){
                    private static final long serialVersionUID = -3722207913631435501L;

                    @Override
                    public void onClick(AjaxRequestTarget target, Serializable ignore) {
                        int index = -1;
                        for (int i = 0; i < ((List)model.getObject()).size() && index == -1; ++i) {
                            if (!itemTO.equals(((List)model.getObject()).get(i))) continue;
                            index = i;
                        }
                        if (index != -1) {
                            ((List)model.getObject()).remove(index);
                            item.getParent().removeAll();
                            target.add(new Component[]{AbstractMappingPanel.this});
                        }
                    }
                }, ActionLink.ActionType.DELETE, "RESOURCE_UPDATE", true).hideLabel();
                item.add(new Component[]{actions});
                intAttrName.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                connObjectKey.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        if (((Boolean)connObjectKey.getModelObject()).booleanValue()) {
                            itemTO.setMandatoryCondition("true");
                            mandatory.setModelObject("true");
                            mandatory.setEnabled(false);
                        } else {
                            itemTO.setMandatoryCondition("false");
                            mandatory.setModelObject("false");
                            mandatory.setEnabled(true);
                        }
                        target.add(new Component[]{mandatory});
                    }
                }});
                password.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = -1107858522700306810L;

                    protected void onUpdate(AjaxRequestTarget target) {
                        extAttrName.setEnabled((Boolean)password.getModelObject() == false);
                        extAttrName.setModelObject((Boolean)password.getModelObject() != false ? "__PASSWORD__" : (String)extAttrName.getModelObject());
                        extAttrName.setRequired((Boolean)password.getModelObject() == false);
                        target.add(new Component[]{extAttrName});
                        AbstractMappingPanel.this.setConnObjectKey(connObjectKey, password);
                        target.add(new Component[]{connObjectKey});
                    }
                }});
                AbstractMappingPanel.this.setConnObjectKey(connObjectKey, password);
                AbstractMappingPanel.this.setAttrNames(intAttrName);
                if (AbstractMappingPanel.this.hidePassword()) {
                    password.setVisible(false);
                    extAttrName.setEnabled(true);
                    if (itemTO.isPassword()) {
                        intAttrName.setEnabled(true);
                    }
                    itemTO.setPassword(false);
                }
                if (hidePurpose) {
                    purpose.setVisible(false);
                }
            }
        };
        this.mappings.setReuseItems(true);
        this.mappingContainer.add(new Component[]{this.mappings});
        this.addMappingBtn = new IndicatingAjaxButton("addMappingBtn"){
            private static final long serialVersionUID = -4804368561204623354L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((List)model.getObject()).add(new ItemTO());
                target.add(new Component[]{AbstractMappingPanel.this});
            }
        };
        this.addMappingBtn.setDefaultFormProcessing(false);
        this.addMappingBtn.setEnabled(addMappingBtnVisible);
        this.mappingContainer.add(new Component[]{this.addMappingBtn});
    }

    protected boolean hidePassword() {
        return true;
    }

    protected abstract IModel<List<String>> getExtAttrNames();

    protected abstract void setAttrNames(AjaxTextFieldPanel var1);

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.passwordLabel.setVisible(false);
        this.purposeLabel.setVisible(true);
    }

    private void setConnObjectKey(AjaxCheckBoxPanel connObjectKey, AjaxCheckBoxPanel password) {
        if (((Boolean)password.getModelObject()).booleanValue()) {
            connObjectKey.setReadOnly(true);
            connObjectKey.setModelObject(false);
        } else {
            connObjectKey.setReadOnly(false);
        }
    }
}

