/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.chartjs.Bar;
import org.apache.syncope.client.console.chartjs.BarChartData;
import org.apache.syncope.client.console.chartjs.BarDataSet;
import org.apache.syncope.client.console.chartjs.Chart;
import org.apache.syncope.client.console.chartjs.ChartJSPanel;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class AnyByRealmWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private static final int MAX_REALMS = 9;
    private Map<String, Integer> usersByRealm;
    private Map<String, Integer> groupsByRealm;
    private String anyType1;
    private Map<String, Integer> any1ByRealm;
    private String anyType2;
    private Map<String, Integer> any2ByRealm;
    private final ChartJSPanel chart;

    public AnyByRealmWidget(String id, Map<String, Integer> usersByRealm, Map<String, Integer> groupsByRealm, String anyType1, Map<String, Integer> any1ByRealm, String anyType2, Map<String, Integer> any2ByRealm) {
        super(id);
        this.usersByRealm = usersByRealm;
        this.groupsByRealm = groupsByRealm;
        this.anyType1 = anyType1;
        this.any1ByRealm = any1ByRealm;
        this.anyType2 = anyType2;
        this.any2ByRealm = any2ByRealm;
        this.setOutputMarkupId(true);
        this.chart = new ChartJSPanel("chart", (IModel<? extends Chart<?>>)Model.of((Serializable)this.build(usersByRealm, groupsByRealm, anyType1, any1ByRealm, anyType2, any2ByRealm)));
        this.add(new Component[]{this.chart});
    }

    private Bar build(Map<String, Integer> usersByRealm, Map<String, Integer> groupsByRealm, String anyType1, Map<String, Integer> any1ByRealm, String anyType2, Map<String, Integer> any2ByRealm) {
        ArrayList labels = new ArrayList();
        ArrayList<Integer> userValues = new ArrayList<Integer>();
        ArrayList<Integer> groupValues = new ArrayList<Integer>();
        ArrayList<Integer> any1Values = new ArrayList<Integer>();
        ArrayList<Integer> any2Values = new ArrayList<Integer>();
        HashSet<String> realmSet = new HashSet<String>();
        realmSet.addAll(usersByRealm.keySet());
        realmSet.addAll(groupsByRealm.keySet());
        if (any1ByRealm != null) {
            realmSet.addAll(any1ByRealm.keySet());
        }
        if (any2ByRealm != null) {
            realmSet.addAll(any2ByRealm.keySet());
        }
        ArrayList realms = new ArrayList(realmSet);
        Collections.sort(realms);
        Bar bar = new Bar();
        bar.getOptions().setScaleBeginAtZero(true);
        bar.getOptions().setBarShowStroke(true);
        bar.getOptions().setBarStrokeWidth(2);
        bar.getOptions().setBarValueSpacing(5);
        bar.getOptions().setBarDatasetSpacing(1);
        bar.getOptions().setResponsive(true);
        bar.getOptions().setMaintainAspectRatio(true);
        bar.getOptions().setMultiTooltipTemplate("<%= datasetLabel %> - <%= value %>");
        for (int i = 0; i < realms.size() && i < 9; ++i) {
            ((BarChartData)bar.getData()).getLabels().add(StringUtils.prependIfMissing((String)StringUtils.substringAfterLast((String)((String)realms.get(i)), (String)"/"), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            userValues.add(usersByRealm.get(realms.get(i)));
            groupValues.add(groupsByRealm.get(realms.get(i)));
            if (any1ByRealm != null) {
                any1Values.add(any1ByRealm.get(realms.get(i)));
            }
            if (any2ByRealm == null) continue;
            any2Values.add(any2ByRealm.get(realms.get(i)));
        }
        BarDataSet userDataSet = new BarDataSet(userValues);
        userDataSet.setFillColor("orange");
        userDataSet.setLabel(this.getString("users"));
        ((BarChartData)bar.getData()).getDatasets().add(userDataSet);
        BarDataSet groupDataSet = new BarDataSet(groupValues);
        groupDataSet.setFillColor("red");
        groupDataSet.setLabel(this.getString("groups"));
        ((BarChartData)bar.getData()).getDatasets().add(groupDataSet);
        if (anyType1 != null) {
            BarDataSet any1DataSet = new BarDataSet(any1Values);
            any1DataSet.setFillColor("green");
            any1DataSet.setLabel(anyType1);
            ((BarChartData)bar.getData()).getDatasets().add(any1DataSet);
        }
        if (anyType2 != null) {
            BarDataSet any2DataSet = new BarDataSet(any2Values);
            any2DataSet.setFillColor("aqua");
            any2DataSet.setLabel(anyType2);
            ((BarChartData)bar.getData()).getDatasets().add(any2DataSet);
        }
        return bar;
    }

    public boolean refresh(Map<String, Integer> usersByRealm, Map<String, Integer> groupsByRealm, String anyType1, Map<String, Integer> any1ByRealm, String anyType2, Map<String, Integer> any2ByRealm) {
        if (!(this.usersByRealm.equals(usersByRealm) && this.groupsByRealm.equals(groupsByRealm) && (this.anyType1 == null && anyType1 == null || this.anyType1.equals(anyType1)) && this.any1ByRealm.equals(any1ByRealm) && (this.anyType2 == null && anyType2 == null || this.anyType2.equals(anyType2)) && this.any2ByRealm.equals(any2ByRealm))) {
            this.usersByRealm = usersByRealm;
            this.groupsByRealm = groupsByRealm;
            this.anyType1 = anyType1;
            this.any1ByRealm = any1ByRealm;
            this.anyType2 = anyType2;
            this.any2ByRealm = any2ByRealm;
            this.chart.setDefaultModelObject(this.build(usersByRealm, groupsByRealm, anyType1, any1ByRealm, anyType2, any2ByRealm));
            return true;
        }
        return false;
    }
}

