/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.syncope.client.console.commons.Constants;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAutoCompleteBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteBehavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.IAutoCompleteRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidator;

public class AjaxTextFieldPanel
extends FieldPanel<String>
implements Cloneable {
    private static final long serialVersionUID = 238940918106696068L;
    private Component questionMarkJexlHelp;
    private List<String> choices = Collections.emptyList();

    public AjaxTextFieldPanel(String id, String name, IModel<String> model) {
        this(id, name, model, true);
    }

    public AjaxTextFieldPanel(String id, String name, IModel<String> model, boolean enableOnChange) {
        super(id, name, model);
        this.questionMarkJexlHelp = Constants.getJEXLPopover((Component)this, TooltipConfig.Placement.right);
        this.add(new Component[]{this.questionMarkJexlHelp.setVisible(false)});
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setShowCompleteListOnFocusGain(true);
        settings.setShowListOnEmptyInput(true);
        settings.setCssClassName("custom-autocomplete-box");
        this.field = new AutoCompleteTextField<String>("textField", model, settings){
            private static final long serialVersionUID = -6648767303091874219L;

            protected Iterator<String> getChoices(String input) {
                return AjaxTextFieldPanel.this.getChoices(input);
            }

            protected AutoCompleteBehavior<String> newAutoCompleteBehavior(IAutoCompleteRenderer<String> renderer, AutoCompleteSettings settings) {
                return new IndicatorAutoCompleteBehavior<String>(renderer, settings){
                    private static final long serialVersionUID = 1070808433195962931L;

                    protected Iterator<String> getChoices(String input) {
                        return AjaxTextFieldPanel.this.getChoices(input);
                    }
                };
            }
        };
        this.add(new Component[]{this.field.setLabel((IModel)new ResourceModel(name, name)).setOutputMarkupId(true)});
        if (enableOnChange && !this.isReadOnly()) {
            this.field.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }});
        }
    }

    public void addValidator(IValidator<? super String> validator) {
        this.field.add(validator);
    }

    public void setChoices(List<String> choices) {
        if (choices != null) {
            this.choices = choices;
        }
    }

    public FieldPanel<String> enableJexlHelp() {
        this.questionMarkJexlHelp.setVisible(true);
        return this;
    }

    public FieldPanel<String> enableJexlHelp(String ... jexlExamples) {
        this.questionMarkJexlHelp = Constants.getJEXLPopover((Component)this, TooltipConfig.Placement.bottom, jexlExamples);
        this.addOrReplace(new Component[]{this.questionMarkJexlHelp.setVisible(true)});
        return this;
    }

    protected Iterator<String> getChoices(String input) {
        Pattern pattern = Pattern.compile(".*" + Pattern.quote(input) + ".*", 2);
        return this.choices.stream().filter(choice -> pattern.matcher((CharSequence)choice).matches()).iterator();
    }

    @Override
    public FieldPanel<String> clone() {
        AjaxTextFieldPanel panel = (AjaxTextFieldPanel)super.clone();
        panel.setChoices(this.choices);
        return panel;
    }
}

