/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.wicket.ajax.markup.html.IndicatorAjaxSubmitLink;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public abstract class AbstractMultiPanel<INNER>
extends AbstractFieldPanel<List<INNER>> {
    private static final long serialVersionUID = -6322397761456513324L;
    private final ListView<INNER> view;
    private final WebMarkupContainer container = new WebMarkupContainer("multiValueContainer");
    private final Form<?> form;

    public AbstractMultiPanel(String id, String name, IModel<List<INNER>> model) {
        super(id, name, model);
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.form = new Form("innerForm");
        this.form.setDefaultButton(null);
        this.container.add(new Component[]{this.form});
        this.view = new InnerView("view", name, model);
        List obj = (List)model.getObject();
        if (obj == null || obj.isEmpty()) {
            this.form.addOrReplace(new Component[]{this.getNoDataFragment(model, name)});
        } else {
            this.form.addOrReplace(new Component[]{this.getDataFragment()});
        }
    }

    public AbstractMultiPanel<INNER> setFormAsMultipart(boolean multipart) {
        this.form.setMultiPart(multipart);
        return this;
    }

    private Fragment getNoDataFragment(IModel<List<INNER>> model, String label) {
        Fragment fragment = new Fragment("content", "noDataFragment", (MarkupContainer)this);
        fragment.add(new Component[]{new Label("field-label", (IModel)new ResourceModel(label, label))});
        fragment.add(new Component[]{this.getPlusFragment(model, label)});
        return fragment;
    }

    private Fragment getDataFragment() {
        Fragment contentFragment = new Fragment("content", "dataFragment", (MarkupContainer)this);
        contentFragment.add(new Component[]{this.view.setOutputMarkupId(true)});
        return contentFragment;
    }

    private Fragment getPlusFragment(final IModel<List<INNER>> model, String label) {
        IndicatorAjaxSubmitLink plus = new IndicatorAjaxSubmitLink("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            protected void onSubmit(AjaxRequestTarget target) {
                ((List)model.getObject()).add(AbstractMultiPanel.this.newModelObject());
                if (((List)model.getObject()).size() == 1) {
                    AbstractMultiPanel.this.form.addOrReplace(new Component[]{AbstractMultiPanel.this.getDataFragment()});
                }
                target.add(new Component[]{AbstractMultiPanel.this.container});
            }

            protected void onError(AjaxRequestTarget target) {
                SyncopeConsoleSession.get().error((Serializable)((Object)this.getString("operation_error")));
                super.onError(target);
                ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        Fragment fragment = new Fragment("panelPlus", "fragmentPlus", (MarkupContainer)this);
        fragment.addOrReplace(new Component[]{plus});
        fragment.setRenderBodyOnly(true);
        return fragment;
    }

    public ListView<INNER> getView() {
        return this.view;
    }

    @Override
    public AbstractMultiPanel<INNER> setModelObject(List<INNER> object) {
        this.view.setModelObject(object);
        return this;
    }

    protected abstract INNER newModelObject();

    protected abstract Panel getItemPanel(ListItem<INNER> var1);

    protected void clearInput(Panel panel) {
    }

    @Override
    public AbstractFieldPanel<List<INNER>> setReadOnly(boolean readOnly) {
        this.container.setEnabled(!readOnly);
        return this;
    }

    public AbstractFieldPanel<List<INNER>> setFormReadOnly(boolean readOnly) {
        this.form.setEnabled(!readOnly);
        return this;
    }

    private final class InnerView
    extends ListView<INNER> {
        private static final long serialVersionUID = -9180479401817023838L;
        private final String label;
        private final IModel<List<INNER>> model;

        private InnerView(String id, String label, IModel<List<INNER>> model) {
            super(id, model);
            this.label = label;
            this.model = model;
        }

        protected void populateItem(final ListItem<INNER> item) {
            final Panel panel = AbstractMultiPanel.this.getItemPanel(item);
            item.add(new Component[]{panel.setRenderBodyOnly(true)});
            IndicatorAjaxSubmitLink minus = new IndicatorAjaxSubmitLink("drop"){
                private static final long serialVersionUID = -7978723352517770644L;

                protected void onSubmit(AjaxRequestTarget target) {
                    ((List)InnerView.this.model.getObject()).remove(item.getModelObject());
                    AbstractMultiPanel.this.clearInput(panel);
                    if (((List)InnerView.this.model.getObject()).isEmpty()) {
                        AbstractMultiPanel.this.form.addOrReplace(new Component[]{AbstractMultiPanel.this.getNoDataFragment(InnerView.this.model, InnerView.this.label)});
                    }
                    target.add(new Component[]{AbstractMultiPanel.this.container});
                }

                protected void onError(AjaxRequestTarget target) {
                    this.onSubmit(target);
                }
            };
            item.add(new Component[]{minus});
            Fragment fragment = item.getIndex() == ((List)this.model.getObject()).size() - 1 ? AbstractMultiPanel.this.getPlusFragment(this.model, this.label) : new Fragment("panelPlus", "emptyFragment", (MarkupContainer)AbstractMultiPanel.this);
            item.add(new Component[]{fragment.setRenderBodyOnly(true)});
        }
    }
}

