/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;

public class BatchResponseColumn<T, S>
extends AbstractColumn<T, S> {
    private static final long serialVersionUID = 7955560320949560716L;
    private static final Logger LOG = LoggerFactory.getLogger(BatchResponseColumn.class);
    private final Map<String, String> results;
    private final String keyFieldName;

    public BatchResponseColumn(Map<String, String> results, String keyFieldName) {
        super((IModel)new Model());
        this.results = results;
        this.keyFieldName = keyFieldName;
    }

    public Component getHeader(String componentId) {
        Label label = new Label(componentId, (IModel)new Model());
        label.setDefaultModel((IModel)new StringResourceModel("batch.result.header", (Component)label, (IModel)new Model((Serializable)((Object)"Result"))));
        return label;
    }

    public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
        try {
            Object key = BeanUtils.getPropertyDescriptor(rowModel.getObject().getClass(), (String)this.keyFieldName).getReadMethod().invoke(rowModel.getObject(), new Object[0]);
            String status = this.results.containsKey(key.toString()) ? this.results.get(key.toString()) : ExecStatus.NOT_ATTEMPTED.name();
            item.add(new Component[]{new Label(componentId, (IModel)new StringResourceModel(status, item, (IModel)new Model((Serializable)((Object)status))))});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | BeansException e) {
            LOG.error("Errore retrieving target key value", e);
        }
    }
}

