/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.ajax.markup.html;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.springframework.util.CollectionUtils;

public class LabelInfo
extends Label {
    private static final long serialVersionUID = 4755868673082976208L;
    private final String title;

    public LabelInfo(String id, String title) {
        super(id, (Serializable)((Object)""));
        this.title = title == null ? "" : StringUtils.abbreviate((String)title, (int)30);
    }

    public LabelInfo(String id, Collection<String> title) {
        super(id, (Serializable)((Object)""));
        if (CollectionUtils.isEmpty(title)) {
            this.title = "";
        } else {
            StringBuilder titleBuilder = new StringBuilder();
            for (String el : title) {
                if (titleBuilder.length() > 0) {
                    titleBuilder.append("; ");
                }
                if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{el})) continue;
                titleBuilder.append(el);
            }
            this.title = StringUtils.abbreviate((String)titleBuilder.toString(), (int)50);
        }
    }

    protected void onComponentTag(ComponentTag tag) {
        tag.put("class", (CharSequence)"fa  fa-info-circle");
        tag.put("style", (CharSequence)"color:red");
        tag.put("title", (CharSequence)this.title);
    }
}

