/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.tasks.SchedTaskWizardBuilder;
import org.apache.syncope.client.console.tasks.TaskDirectoryPanel;
import org.apache.syncope.client.console.tasks.TaskStartAtTogglePanel;
import org.apache.syncope.client.console.tasks.TemplatesTogglePanel;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.SchedTaskTO;
import org.apache.syncope.common.lib.to.TemplatableTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.time.Duration;

public abstract class SchedTaskDirectoryPanel<T extends SchedTaskTO>
extends TaskDirectoryPanel<T>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    protected TaskType taskType;
    protected final Class<T> reference;
    protected T schedTaskTO;
    private final TaskStartAtTogglePanel startAt;
    protected final TemplatesTogglePanel templates;

    protected SchedTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, final TaskType taskType, Class<T> reference, PageReference pageRef) {
        super(baseModal, multiLevelPanelRef, pageRef);
        this.taskType = taskType;
        this.reference = reference;
        try {
            this.schedTaskTO = (SchedTaskTO)reference.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failure instantiating task", (Throwable)e);
        }
        this.addNewItemPanelBuilder(new SchedTaskWizardBuilder<T>(taskType, this.schedTaskTO, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"TASK_CREATE");
        this.enableExitButton();
        this.setFooterVisibility(false);
        this.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                SchedTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
            }
        }});
        this.startAt = new TaskStartAtTogglePanel(this.container, pageRef);
        this.addInnerObject(new Component[]{this.startAt});
        this.templates = new TemplatesTogglePanel(this.getActualId(), (MarkupContainer)this, pageRef){
            private static final long serialVersionUID = -8765794727538618705L;

            @Override
            protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
                targetObject.getTemplates().put(type, anyTO);
                new TaskRestClient().update(taskType, (SchedTaskTO)SchedTaskTO.class.cast(targetObject));
                return targetObject;
            }
        };
        this.addInnerObject(new Component[]{this.templates});
    }

    protected SchedTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, final TaskType taskType, Class<T> reference, PageReference pageRef, boolean wizardInModal) {
        super(baseModal, multiLevelPanelRef, pageRef, wizardInModal);
        this.taskType = taskType;
        this.reference = reference;
        try {
            this.schedTaskTO = (SchedTaskTO)reference.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failure instantiating task", (Throwable)e);
        }
        this.addNewItemPanelBuilder(new SchedTaskWizardBuilder<T>(taskType, this.schedTaskTO, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"TASK_CREATE");
        this.enableExitButton();
        this.setFooterVisibility(false);
        this.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                SchedTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
            }
        }});
        this.startAt = new TaskStartAtTogglePanel(this.container, pageRef);
        this.addInnerObject(new Component[]{this.startAt});
        this.templates = new TemplatesTogglePanel(this.getActualId(), (MarkupContainer)this, pageRef){
            private static final long serialVersionUID = -8765794727538618705L;

            @Override
            protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
                targetObject.getTemplates().put(type, anyTO);
                new TaskRestClient().update(taskType, (SchedTaskTO)SchedTaskTO.class.cast(targetObject));
                return targetObject;
            }
        };
        this.addInnerObject(new Component[]{this.templates});
    }

    protected SchedTaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, final TaskType taskType, Class<T> reference, PageReference pageRef, String id) {
        super(baseModal, multiLevelPanelRef, pageRef, id);
        this.taskType = taskType;
        this.reference = reference;
        try {
            this.schedTaskTO = (SchedTaskTO)reference.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LOG.error("Failure instantiating task", (Throwable)e);
        }
        this.addNewItemPanelBuilder(new SchedTaskWizardBuilder<T>(taskType, this.schedTaskTO, pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"TASK_CREATE");
        this.setFooterVisibility(false);
        this.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = 3780176123730676296L;

            protected void onTimer(AjaxRequestTarget target) {
                SchedTaskDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
            }
        }});
        this.startAt = new TaskStartAtTogglePanel(this.container, pageRef);
        this.addOrReplaceInnerObject(new Component[]{this.startAt});
        this.templates = new TemplatesTogglePanel(this.getActualId(), (MarkupContainer)this, pageRef){
            private static final long serialVersionUID = 5463425091347504892L;

            @Override
            protected Serializable onApplyInternal(TemplatableTO targetObject, String type, AnyTO anyTO) {
                targetObject.getTemplates().put(type, anyTO);
                new TaskRestClient().update(taskType, (SchedTaskTO)SchedTaskTO.class.cast(targetObject));
                return targetObject;
            }
        };
        this.addOrReplaceInnerObject(new Component[]{this.templates});
    }

    protected List<IColumn<T, String>> getFieldColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.add((IColumn<T, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<T, String>)new PropertyColumn<T, String>((IModel)new StringResourceModel("jobDelegate", (Component)this), "jobDelegate", "jobDelegate"){
            private static final long serialVersionUID = -3223917055078733093L;

            public void populateItem(Item<ICellPopulator<T>> item, String componentId, IModel<T> rowModel) {
                IModel model = this.getDataModel(rowModel);
                if (model != null && model.getObject() instanceof String) {
                    String value = (String)String.class.cast(model.getObject());
                    if (value.length() > 20) {
                        item.add(new Component[]{new Label(componentId, (IModel)new Model((Serializable)((Object)("..." + value.substring(value.length() - 17)))))});
                    } else {
                        item.add(new Component[]{new Label(componentId, this.getDataModel(rowModel))});
                    }
                } else {
                    super.populateItem(item, componentId, rowModel);
                }
            }
        });
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this), null, "lastExec"));
        columns.add((IColumn<T, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this), null, "nextExec"));
        columns.add((IColumn<T, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<T, String>)new BooleanPropertyColumn((IModel<String>)new StringResourceModel("active", (Component)this), "active", "active"));
        columns.add((IColumn<T, String>)new AbstractColumn<T, String>((IModel)new Model((Serializable)((Object)"")), "running"){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId, IModel<T> rowModel) {
                Object panel;
                try {
                    JobTO jobTO = ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).getJob(((SchedTaskTO)rowModel.getObject()).getKey());
                    panel = new JobActionPanel(componentId, jobTO, false, (Component)SchedTaskDirectoryPanel.this, SchedTaskDirectoryPanel.this.pageRef);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.ENABLE, (String)String.format("%s,%s", "TASK_EXECUTE", "TASK_UPDATE"));
                }
                catch (Exception e) {
                    LOG.error("Could not get job for task {}", (Object)((SchedTaskTO)rowModel.getObject()).getKey(), (Object)e);
                    panel = new Label(componentId, (IModel)Model.of());
                }
                cellItem.add(new Component[]{panel});
            }

            public String getCssClass() {
                return "col-xs-1";
            }
        });
        return columns;
    }

    @Override
    protected final List<IColumn<T, String>> getColumns() {
        ArrayList<IColumn<T, String>> columns = new ArrayList<IColumn<T, String>>();
        columns.addAll(this.getFieldColumns());
        return columns;
    }

    @Override
    public ActionsPanel<T> getActions(final IModel<T> model) {
        ActionsPanel<T> panel = super.getActions(model);
        final SchedTaskTO taskTO = (SchedTaskTO)model.getObject();
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskDirectoryPanel.this.viewTask(taskTO, target);
            }
        }, ActionLink.ActionType.VIEW_EXECUTIONS, "TASK_READ");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskDirectoryPanel.this.send((IEventSink)SchedTaskDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent(((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).readTask(SchedTaskDirectoryPanel.this.taskType, ((SchedTaskTO)model.getObject()).getKey()), target).setResourceModel((IModel<String>)new StringResourceModel("inner.task.edit", (Component)SchedTaskDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)((Object)ActionLink.ActionType.EDIT), (Object)model.getObject())))));
            }
        }, ActionLink.ActionType.EDIT, "TASK_UPDATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskTO clone = (SchedTaskTO)SerializationUtils.clone((Serializable)((Serializable)model.getObject()));
                clone.setKey(null);
                SchedTaskDirectoryPanel.this.send((IEventSink)SchedTaskDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<SchedTaskTO>(clone, target).setResourceModel((IModel<String>)new StringResourceModel("inner.task.clone", (Component)SchedTaskDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)((Object)ActionLink.ActionType.CLONE), (Object)model.getObject())))));
            }
        }, ActionLink.ActionType.CLONE, "TASK_CREATE");
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                SchedTaskDirectoryPanel.this.startAt.setExecutionDetail(((SchedTaskTO)model.getObject()).getKey(), ((SchedTaskTO)model.getObject()).getName(), target);
                SchedTaskDirectoryPanel.this.startAt.toggle(target, true);
            }
        }, ActionLink.ActionType.EXECUTE, "TASK_EXECUTE");
        this.addFurtherActions(panel, model);
        panel.add(new ActionLink<T>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, T ignore) {
                try {
                    ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).delete(SchedTaskDirectoryPanel.this.taskType, taskTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)SchedTaskDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{SchedTaskDirectoryPanel.this.container});
                    SchedTaskDirectoryPanel.this.getTogglePanel().close(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting propagation task {}", (Object)taskTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)SchedTaskDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "TASK_DELETE", true);
        return panel;
    }

    protected void addFurtherActions(ActionsPanel<T> panel, IModel<T> model) {
    }

    @Override
    protected String paginatorRowsKey() {
        return "schedtasks.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.DELETE);
        batches.add(ActionLink.ActionType.EXECUTE);
        batches.add(ActionLink.ActionType.DRYRUN);
        return batches;
    }

    @Override
    protected SchedTasksProvider<T> dataProvider() {
        return new SchedTasksProvider<T>(this.reference, this.taskType, this.rows);
    }

    protected class SchedTasksProvider<T extends SchedTaskTO>
    extends TaskDataProvider<T> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final Class<T> reference;

        public SchedTasksProvider(Class<T> reference, TaskType taskType, int paginatorRows) {
            super(paginatorRows, taskType);
            this.setSort("name", SortOrder.ASCENDING);
            this.reference = reference;
        }

        public long size() {
            return ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).count(this.taskType);
        }

        public Iterator<T> iterator(long first, long count) {
            int page = (int)first / this.paginatorRows;
            return ((TaskRestClient)SchedTaskDirectoryPanel.this.restClient).list(this.reference, (page < 0 ? 0 : page) + 1, this.paginatorRows, (SortParam<String>)this.getSort()).iterator();
        }
    }
}

