/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.PrivilegeWizardBuilder;
import org.apache.syncope.client.console.rest.ApplicationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ApplicationTO;
import org.apache.syncope.common.lib.to.PrivilegeTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;

public class PrivilegeDirectoryPanel
extends DirectoryPanel<PrivilegeTO, PrivilegeTO, DirectoryDataProvider<PrivilegeTO>, ApplicationRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 6524374026036584897L;
    private final ApplicationTO application;
    private final BaseModal<PrivilegeTO> baseModal;

    protected PrivilegeDirectoryPanel(BaseModal<PrivilegeTO> baseModal, ApplicationTO application, PageReference pageRef) {
        super("content", pageRef, false);
        this.baseModal = baseModal;
        this.application = application;
        this.restClient = new ApplicationRestClient();
        this.disableCheckBoxes();
        this.enableExitButton();
        this.addNewItemPanelBuilder(new PrivilegeWizardBuilder(application, new PrivilegeTO(), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"APPLICATION_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<PrivilegeTO, String>> getColumns() {
        ArrayList<IColumn<PrivilegeTO, String>> columns = new ArrayList<IColumn<PrivilegeTO, String>>();
        columns.add((IColumn<PrivilegeTO, String>)new PropertyColumn((IModel)new ResourceModel("key"), (Object)"key", "key"));
        columns.add((IColumn<PrivilegeTO, String>)new PropertyColumn((IModel)new ResourceModel("description"), (Object)"description", "description"));
        return columns;
    }

    @Override
    protected ActionsPanel<PrivilegeTO> getActions(final IModel<PrivilegeTO> model) {
        ActionsPanel<PrivilegeTO> panel = super.getActions(model);
        panel.add(new ActionLink<PrivilegeTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PrivilegeTO ignore) {
                PrivilegeDirectoryPanel.this.getTogglePanel().close(target);
                PrivilegeDirectoryPanel.this.send((IEventSink)PrivilegeDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "APPLICATION_UPDATE");
        panel.add(new ActionLink<PrivilegeTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PrivilegeTO ignore) {
                try {
                    PrivilegeDirectoryPanel.this.application.getPrivileges().remove(model.getObject());
                    ((ApplicationRestClient)PrivilegeDirectoryPanel.this.restClient).update(PrivilegeDirectoryPanel.this.application);
                    SyncopeConsoleSession.get().success((Serializable)((Object)PrivilegeDirectoryPanel.this.getString("operation_succeeded")));
                    PrivilegeDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((PrivilegeTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)PrivilegeDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "APPLICATION_UPDATE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected PrivilegeDataProvider dataProvider() {
        return new PrivilegeDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "privilege.paginator.rows";
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected class PrivilegeDataProvider
    extends DirectoryDataProvider<PrivilegeTO> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<PrivilegeTO> comparator;

        public PrivilegeDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("description", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<PrivilegeTO>(this);
        }

        public Iterator<PrivilegeTO> iterator(long first, long count) {
            List list = PrivilegeDirectoryPanel.this.application.getPrivileges();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return PrivilegeDirectoryPanel.this.application.getPrivileges().size();
        }

        public IModel<PrivilegeTO> model(PrivilegeTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

