/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.DelegationRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.DelegationTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class DelegationDirectoryPanel
extends DirectoryPanel<DelegationTO, DelegationTO, DelegationDataProvider, DelegationRestClient> {
    private static final long serialVersionUID = 28300423726398L;
    private final UserRestClient userRestClient = new UserRestClient();

    protected DelegationDirectoryPanel(String id, Builder builder) {
        super(id, builder);
        this.disableCheckBoxes();
        this.setShowResultPage(true);
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
    }

    @Override
    protected DelegationDataProvider dataProvider() {
        return new DelegationDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "delegation.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    @Override
    protected List<IColumn<DelegationTO, String>> getColumns() {
        ArrayList<IColumn<DelegationTO, String>> columns = new ArrayList<IColumn<DelegationTO, String>>();
        columns.add((IColumn<DelegationTO, String>)new KeyPropertyColumn((IModel<String>)new ResourceModel("key"), "key", "key"));
        columns.add((IColumn<DelegationTO, String>)new AbstractColumn<DelegationTO, String>((IModel)new ResourceModel("delegating"), "delegating"){

            public void populateItem(Item<ICellPopulator<DelegationTO>> cellItem, String componentId, IModel<DelegationTO> rowModel) {
                String delegating = ((DelegationTO)rowModel.getObject()).getDelegating();
                if (SyncopeConsoleSession.get().owns("USER_READ", new String[0])) {
                    delegating = ((UserTO)DelegationDirectoryPanel.this.userRestClient.read(delegating)).getUsername();
                } else if (SyncopeConsoleSession.get().getSelfTO().getKey().equals(delegating)) {
                    delegating = SyncopeConsoleSession.get().getSelfTO().getUsername();
                }
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)delegating))});
            }
        });
        columns.add((IColumn<DelegationTO, String>)new AbstractColumn<DelegationTO, String>((IModel)new ResourceModel("delegated"), "delegated"){

            public void populateItem(Item<ICellPopulator<DelegationTO>> cellItem, String componentId, IModel<DelegationTO> rowModel) {
                String delegated = ((DelegationTO)rowModel.getObject()).getDelegated();
                if (SyncopeConsoleSession.get().owns("USER_READ", new String[0])) {
                    delegated = ((UserTO)DelegationDirectoryPanel.this.userRestClient.read(delegated)).getUsername();
                } else if (SyncopeConsoleSession.get().getSelfTO().getKey().equals(delegated)) {
                    delegated = SyncopeConsoleSession.get().getSelfTO().getUsername();
                }
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)delegated))});
            }
        });
        columns.add((IColumn<DelegationTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("start", (Component)this), "start", "start"));
        columns.add((IColumn<DelegationTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("end", (Component)this), "end", "end"));
        columns.add((IColumn<DelegationTO, String>)new PropertyColumn((IModel)new ResourceModel("roles"), null, "roles"));
        return columns;
    }

    @Override
    public ActionsPanel<DelegationTO> getActions(final IModel<DelegationTO> model) {
        ActionsPanel<DelegationTO> panel = super.getActions(model);
        panel.add(new ActionLink<DelegationTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, DelegationTO ignore) {
                DelegationDirectoryPanel.this.send((IEventSink)DelegationDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "");
        panel.add(new ActionLink<DelegationTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, DelegationTO ignore) {
                try {
                    ((DelegationRestClient)DelegationDirectoryPanel.this.restClient).delete(((DelegationTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)DelegationDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{DelegationDirectoryPanel.this.container});
                }
                catch (Exception e) {
                    DirectoryPanel.LOG.error("While deleting {}", (Object)((DelegationTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)DelegationDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "", true);
        return panel;
    }

    protected class DelegationDataProvider
    extends DirectoryDataProvider<DelegationTO> {
        private static final long serialVersionUID = 28297380054779L;
        private final SortableDataProviderComparator<DelegationTO> comparator;

        public DelegationDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.comparator = new SortableDataProviderComparator<DelegationTO>(this);
        }

        public Iterator<DelegationTO> iterator(long first, long count) {
            List<DelegationTO> result = ((DelegationRestClient)DelegationDirectoryPanel.this.restClient).list();
            Collections.sort(result, this.comparator);
            return result.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((DelegationRestClient)DelegationDirectoryPanel.this.restClient).list().size();
        }

        public IModel<DelegationTO> model(DelegationTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }

    public static abstract class Builder
    extends DirectoryPanel.Builder<DelegationTO, DelegationTO, DelegationRestClient> {
        private static final long serialVersionUID = 5530948153889495221L;

        public Builder(PageReference pageRef) {
            super(new DelegationRestClient(), pageRef);
        }

        @Override
        protected WizardMgtPanel<DelegationTO> newInstance(String id, boolean wizardInModal) {
            return new DelegationDirectoryPanel(id, this);
        }
    }
}

