/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.AjaxFallbackDataTable;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public abstract class DataTablePanel<T extends Serializable, S>
extends Panel {
    private static final long serialVersionUID = -7264400471578272966L;
    protected CheckGroup<T> group;
    protected AjaxFallbackDataTable<T, S> dataTable;
    protected IModel<Collection<T>> model = new IModel<Collection<T>>(){
        private static final long serialVersionUID = 4886729136344643465L;
        private final Collection<T> values = new HashSet();

        public Collection<T> getObject() {
            return new HashSet(this.values);
        }

        public void setObject(Collection<T> selected) {
            Collection all = DataTablePanel.this.getGroupModelObjects();
            this.values.removeAll(all);
            this.values.addAll(selected);
        }

        public void detach() {
        }
    };

    public DataTablePanel(String id) {
        super(id);
    }

    public final void setCurrentPage(long page) {
        this.dataTable.setCurrentPage(page);
    }

    public final long getRowCount() {
        return this.dataTable.getRowCount();
    }

    public final long getCurrentPage() {
        return this.dataTable.getCurrentPage();
    }

    public final long getPageCount() {
        return this.dataTable.getPageCount();
    }

    public void setItemsPerPage(int resourcePaginatorRows) {
        this.dataTable.setItemsPerPage(resourcePaginatorRows);
    }

    protected Collection<T> getGroupModelObjects() {
        HashSet<Object> res = new HashSet<Object>();
        Component rows = this.group.get("dataTable:body:rows");
        if (rows instanceof DataGridView) {
            Iterator iter = ((DataGridView)rows).getItems();
            while (iter.hasNext()) {
                res.add(((Item)iter.next()).getModelObject());
            }
        }
        return res;
    }
}

