/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDataProvider
extends DirectoryDataProvider<Serializable> {
    private static final long serialVersionUID = 3189980210236051840L;
    protected static final Logger LOG = LoggerFactory.getLogger(ResourceDataProvider.class);
    private final PageReference pageRef;
    protected int currentPage;
    private String keyword;
    private final ResourceRestClient restClient = new ResourceRestClient();

    public ResourceDataProvider(int paginatorRows, PageReference pageRef, String keyword) {
        super(paginatorRows);
        this.setSort("keySortParam", SortOrder.ASCENDING);
        this.pageRef = pageRef;
        this.keyword = keyword;
    }

    public Iterator<ResourceTO> iterator(long first, long count) {
        List<Object> result = Collections.emptyList();
        try {
            this.currentPage = (int)first / this.paginatorRows;
            if (this.currentPage < 0) {
                this.currentPage = 0;
            }
            result = StringUtils.isBlank((CharSequence)this.keyword) ? this.restClient.list() : this.restClient.list().stream().filter(resource -> resource.getKey().toLowerCase().contains(this.keyword)).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.error("While searching", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
            Optional target = RequestCycle.get().find(AjaxRequestTarget.class);
            target.ifPresent(ajaxRequestTarget -> ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)ajaxRequestTarget));
        }
        SortParam sortParam = this.getSort();
        if (sortParam != null) {
            result.sort(this.getComparator((SortParam<String>)sortParam));
        }
        return result.subList((int)first, (int)first + (int)count).iterator();
    }

    private Comparator<ResourceTO> getComparator(SortParam<String> sortParam) {
        Comparator<ResourceTO> comparator;
        switch ((String)sortParam.getProperty()) {
            case "keySortParam": {
                comparator = Comparator.nullsFirst(Comparator.comparing(item -> item.getKey().toLowerCase()));
                break;
            }
            case "connectorDisplayNameSortParam": {
                comparator = Comparator.nullsFirst(Comparator.comparing(item -> item.getConnectorDisplayName().toLowerCase()));
                break;
            }
            default: {
                throw new IllegalStateException("The sort param " + (String)sortParam.getProperty() + " is not correct");
            }
        }
        if (!sortParam.isAscending()) {
            comparator = comparator.reversed();
        }
        return comparator;
    }

    public long size() {
        long result = 0L;
        try {
            result = StringUtils.isBlank((CharSequence)this.keyword) ? (long)this.restClient.list().size() : this.restClient.list().stream().filter(resource -> resource.getKey().toLowerCase().contains(this.keyword)).count();
        }
        catch (Exception e) {
            LOG.error("While requesting for size()", (Throwable)e);
            SyncopeConsoleSession.get().onException(e);
            RequestCycle.get().find(AjaxRequestTarget.class).ifPresent(target -> ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target));
        }
        return result;
    }

    public IModel<Serializable> model(Serializable object) {
        return new CompoundPropertyModel((Object)((ResourceTO)object));
    }

    public int getCurrentPage() {
        return this.currentPage;
    }
}

