/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons;

import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleApplication;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.DefaultPreviewer;
import org.springframework.util.ClassUtils;

public final class PreviewUtils {
    private final ClassPathScanImplementationLookup classPathScanImplementationLookup = (ClassPathScanImplementationLookup)SyncopeConsoleApplication.get().getServletContext().getAttribute("CLASSPATH_LOOKUP");

    public static PreviewUtils getInstance() {
        return new PreviewUtils();
    }

    private PreviewUtils() {
    }

    public AbstractBinaryPreviewer getDefaultPreviewer(String mimeType) {
        return new DefaultPreviewer("previewer", mimeType);
    }

    public AbstractBinaryPreviewer getPreviewer(String mimeType) {
        if (StringUtils.isBlank((CharSequence)mimeType)) {
            return null;
        }
        Class<? extends AbstractBinaryPreviewer> previewer = this.classPathScanImplementationLookup.getPreviewerClass(mimeType);
        try {
            return previewer == null ? null : (AbstractBinaryPreviewer)((Object)ClassUtils.getConstructorIfAvailable(previewer, (Class[])new Class[]{String.class, String.class}).newInstance("previewer", mimeType));
        }
        catch (Exception e) {
            return null;
        }
    }
}

