/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.maven.xar;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.synapse.maven.xar.AbstractXarMojo;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class XarMojo
extends AbstractXarMojo {
    private String outputDirectory;
    private String xarName;
    private JarArchiver jarArchiver;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private String classifier;
    private boolean primaryArtifact;
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException {
        File xarFile = new File(this.outputDirectory, this.xarName + ".xar");
        this.getLog().info((CharSequence)("Generating XAR " + xarFile.getAbsolutePath()));
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.jarArchiver);
        archiver.setOutputFile(xarFile);
        try {
            this.buildArchive((Archiver)this.jarArchiver);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Unable to build archive", (Exception)((Object)e));
        }
        try {
            archiver.createArchive(this.project, this.archive);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create archive", e);
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.project, "xar", this.classifier, xarFile);
        } else {
            Artifact artifact = this.project.getArtifact();
            if (this.primaryArtifact) {
                artifact.setFile(xarFile);
            } else if (artifact.getFile() == null || artifact.getFile().isDirectory()) {
                artifact.setFile(xarFile);
            } else {
                this.projectHelper.attachArtifact(this.project, "xar", xarFile);
            }
        }
    }
}

