/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.maven.xar;

import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.apache.synapse.maven.xar.ClassScannerException;
import org.apache.synapse.maven.xar.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLocator
implements ClassVisitor {
    private final String serviceClassName;
    private Class<?> serviceClass;
    private List<String> implementations = new LinkedList<String>();

    public ServiceLocator(String serviceClassName) {
        this.serviceClassName = serviceClassName;
    }

    public String getServiceClassName() {
        return this.serviceClassName;
    }

    public List<String> getImplementations() {
        return this.implementations;
    }

    @Override
    public void init(ClassLoader classLoader) throws ClassScannerException {
        try {
            this.serviceClass = classLoader.loadClass(this.serviceClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ClassScannerException("Class " + this.serviceClassName + " not found");
        }
    }

    @Override
    public void visit(Class<?> clazz) throws ClassScannerException {
        if (this.serviceClass.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers())) {
            this.implementations.add(clazz.getName());
        }
    }
}

