/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.maven.xar;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.synapse.maven.xar.ClassScannerException;
import org.apache.synapse.maven.xar.ClassVisitor;

public class ClassScanner {
    private final File dir;
    private List<File> classpath = new LinkedList<File>();
    private List<ClassVisitor> visitors = new LinkedList<ClassVisitor>();
    private ClassLoader loader;

    public ClassScanner(File dir) {
        this.dir = dir;
        this.addToClasspath(dir);
    }

    public void addToClasspath(File file) {
        this.classpath.add(file);
    }

    public void addVisitor(ClassVisitor visitor) {
        this.visitors.add(visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws ClassScannerException {
        if (this.visitors.isEmpty()) {
            return;
        }
        ArrayList<URL> urls = new ArrayList<URL>(this.classpath.size());
        for (File classpathEntry : this.classpath) {
            try {
                urls.add(classpathEntry.toURL());
            }
            catch (MalformedURLException e) {
                throw new ClassScannerException("Unable to build classpath", e);
            }
        }
        this.loader = URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]));
        try {
            for (ClassVisitor visitor : this.visitors) {
                visitor.init(this.loader);
            }
            this.scan(this.dir, null);
        }
        finally {
            this.loader = null;
        }
    }

    private void scan(File dir, String packageName) throws ClassScannerException {
        File[] children;
        for (File child : children = dir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".class");
            }
        })) {
            Class<?> clazz;
            String name = child.getName();
            if (child.isDirectory()) {
                this.scan(child, packageName == null ? name : packageName + "." + name);
                continue;
            }
            StringBuilder className = new StringBuilder();
            if (packageName != null) {
                className.append(packageName).append('.');
            }
            className.append(name.substring(0, name.length() - 6));
            try {
                clazz = this.loader.loadClass(className.toString());
            }
            catch (ClassNotFoundException e) {
                throw new ClassScannerException("Unable to load class " + className, e);
            }
            for (ClassVisitor visitor : this.visitors) {
                visitor.visit(clazz);
            }
        }
    }
}

