/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.maven.xar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactCollector;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.DebugResolutionListener;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.synapse.maven.xar.ClassScanner;
import org.apache.synapse.maven.xar.ClassScannerException;
import org.apache.synapse.maven.xar.ServiceLocator;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXarMojo
extends AbstractMojo
implements LogEnabled {
    private static final String[] defaultRuntimeExcludes = new String[]{"org.apache.synapse:synapse-core:jar", "commons-logging:commons-logging-api:jar"};
    private static final String[] serviceClassNames = new String[]{"org.apache.synapse.config.xml.MediatorFactory", "org.apache.synapse.config.xml.MediatorSerializer", "org.apache.synapse.config.xml.StartupFactory"};
    private File baseDir;
    protected MavenProject project;
    private ArtifactRepository localRepository;
    private List remoteArtifactRepositories;
    private ArtifactMetadataSource artifactMetadataSource;
    private ArtifactCollector artifactCollector;
    private MavenProjectBuilder projectBuilder;
    private ArtifactFactory artifactFactory;
    private File buildOutputDirectory;
    private File tmpDirectory;
    private boolean includeDependencies;
    private boolean generateMetadata;
    private Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected void buildArchive(Archiver archiver) throws ArchiverException, MojoExecutionException {
        Log log = this.getLog();
        log.debug((CharSequence)("Using base directory: " + this.baseDir));
        archiver.addDirectory(this.buildOutputDirectory);
        if (this.includeDependencies) {
            log.debug((CharSequence)"Adding dependencies ...");
            this.addDependencies(archiver);
        }
        if (this.generateMetadata) {
            log.debug((CharSequence)"Generating XAR metadata ...");
            this.generateMetadata(archiver);
        }
    }

    private void addDependencies(Archiver archiver) throws ArchiverException, MojoExecutionException {
        Log log = this.getLog();
        AndArtifactFilter filter = new AndArtifactFilter();
        filter.add((ArtifactFilter)new ScopeArtifactFilter("runtime"));
        filter.add(new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return !artifact.isOptional();
            }
        });
        filter.add((ArtifactFilter)new TypeArtifactFilter("jar"));
        filter.add(this.buildSynapseRuntimeArtifactFilter());
        for (Artifact artifact : AbstractXarMojo.filterArtifacts(this.project.getArtifacts(), (ArtifactFilter)filter)) {
            String targetFileName = artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension();
            log.info((CharSequence)("Adding " + targetFileName + " (scope " + artifact.getScope() + ")"));
            archiver.addFile(artifact.getFile(), "lib/" + targetFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateMetadata(Archiver archiver) throws ArchiverException, MojoExecutionException {
        Log log = this.getLog();
        File tmpServicesDir = new File(new File(this.tmpDirectory, "META-INF"), "services");
        File buildServicesDir = new File(new File(this.buildOutputDirectory, "META-INF"), "services");
        if (!tmpServicesDir.exists() && !tmpServicesDir.mkdirs()) {
            throw new MojoExecutionException("Error while creating the directory: " + tmpServicesDir.getPath());
        }
        log.debug((CharSequence)"Initializing class scanner ...");
        ClassScanner scanner = new ClassScanner(this.buildOutputDirectory);
        for (Artifact artifact : AbstractXarMojo.filterArtifacts(this.project.getArtifacts(), (ArtifactFilter)new ScopeArtifactFilter("compile"))) {
            scanner.addToClasspath(artifact.getFile());
        }
        ArrayList<ServiceLocator> serviceLocators = new ArrayList<ServiceLocator>(serviceClassNames.length);
        for (String serviceClassName : serviceClassNames) {
            File file = new File(buildServicesDir, serviceClassName);
            if (file.exists()) {
                log.debug((CharSequence)(file + " exists; don't scan for " + serviceClassName + " implementation"));
                continue;
            }
            ServiceLocator sl = new ServiceLocator(serviceClassName);
            serviceLocators.add(sl);
            scanner.addVisitor(sl);
        }
        try {
            scanner.scan();
        }
        catch (ClassScannerException e) {
            throw new MojoExecutionException("Failed to scan classes for services", (Exception)e);
        }
        for (ServiceLocator sl : serviceLocators) {
            File file = new File(tmpServicesDir, sl.getServiceClassName());
            if (sl.getImplementations().isEmpty()) continue;
            String destFileName = "META-INF/services/" + sl.getServiceClassName();
            log.info((CharSequence)("Generating " + destFileName));
            try {
                OutputStreamWriter out = new OutputStreamWriter(new FileOutputStream(file));
                try {
                    for (String impl : sl.getImplementations()) {
                        log.debug((CharSequence)("  " + impl));
                        out.write(impl);
                        out.write("\n");
                    }
                }
                finally {
                    ((Writer)out).close();
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create temporary file " + file, (Exception)e);
            }
            archiver.addFile(file, destFileName);
        }
    }

    private ArtifactFilter buildSynapseRuntimeArtifactFilter() throws MojoExecutionException {
        final HashMap<String, Artifact> artifacts = new HashMap<String, Artifact>();
        for (Artifact artifact : this.getSynapseRuntimeArtifacts()) {
            artifacts.put(artifact.getDependencyConflictId(), artifact);
        }
        final HashSet<String> defaultExclusionSet = new HashSet<String>(Arrays.asList(defaultRuntimeExcludes));
        return new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                Artifact runtimeArtifact = (Artifact)artifacts.get(artifact.getDependencyConflictId());
                if (runtimeArtifact == null) {
                    return !defaultExclusionSet.contains(artifact.getDependencyConflictId());
                }
                if (!runtimeArtifact.getVersion().equals(artifact.getVersion())) {
                    AbstractXarMojo.this.getLog().warn((CharSequence)("Possible runtime version conflict for " + artifact.getArtifactId() + ": XAR depends on " + artifact.getVersion() + ", Synapse runtime provides " + runtimeArtifact.getVersion()));
                }
                return false;
            }
        };
    }

    private Set<Artifact> getSynapseRuntimeArtifacts() throws MojoExecutionException {
        Set synapseRuntimeDeps;
        MavenProject synapseCoreProject;
        Log log = this.getLog();
        log.debug((CharSequence)"Looking for synapse-core artifact in XAR project dependencies ...");
        Artifact synapseCore = null;
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            if (!artifact.getGroupId().equals("org.apache.synapse") || !artifact.getArtifactId().equals("synapse-core")) continue;
            synapseCore = artifact;
            break;
        }
        if (synapseCore == null) {
            throw new MojoExecutionException("Could not locate dependency on synapse-core");
        }
        log.debug((CharSequence)("Loading project data for " + synapseCore + " ..."));
        try {
            synapseCoreProject = this.projectBuilder.buildFromRepository(synapseCore, this.remoteArtifactRepositories, this.localRepository);
        }
        catch (ProjectBuildingException e) {
            throw new MojoExecutionException("Unable to retrieve project information for " + synapseCore, (Exception)((Object)e));
        }
        try {
            synapseRuntimeDeps = synapseCoreProject.createArtifacts(this.artifactFactory, "runtime", (ArtifactFilter)new TypeArtifactFilter("jar"));
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException("Unable to get project dependencies for " + synapseCore, (Exception)((Object)e));
        }
        log.debug((CharSequence)("Direct runtime dependencies for " + synapseCore + " :"));
        this.logArtifacts(synapseRuntimeDeps);
        log.debug((CharSequence)("Resolving transitive dependencies for " + synapseCore + " ..."));
        try {
            synapseRuntimeDeps = this.artifactCollector.collect(synapseRuntimeDeps, synapseCoreProject.getArtifact(), synapseCoreProject.getManagedVersionMap(), this.localRepository, this.remoteArtifactRepositories, this.artifactMetadataSource, null, Collections.singletonList(new DebugResolutionListener(this.logger))).getArtifacts();
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to resolve transitive dependencies for " + synapseCore);
        }
        log.debug((CharSequence)("All runtime dependencies for " + synapseCore + " :"));
        this.logArtifacts(synapseRuntimeDeps);
        return synapseRuntimeDeps;
    }

    private void logArtifacts(Collection<Artifact> collection) {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(collection);
        Collections.sort(artifacts, new Comparator<Artifact>(){

            @Override
            public int compare(Artifact o1, Artifact o2) {
                return o1.getArtifactId().compareTo(o2.getArtifactId());
            }
        });
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("  " + artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension()));
        }
    }

    private static Set<Artifact> filterArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!filter.include(artifact)) continue;
            result.add(artifact);
        }
        return result;
    }
}

