/*
 * Decompiled with CFR 0.152.
 */
package samples.util;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionParser;
import org.apache.axis2.util.OptionsValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SampleAxis2Server {
    private static final Log log = LogFactory.getLog(SimpleHTTPServer.class);
    int port = -1;
    public static int DEFAULT_PORT = 9000;

    public static void main(String[] args) throws Exception {
        SampleAxis2Server.startServer(args);
    }

    public static ListenerManager startServer(String[] args) {
        String repoLocation = null;
        String confLocation = null;
        CommandLineOptionParser optionsParser = new CommandLineOptionParser(args);
        List invalidOptionsList = optionsParser.getInvalidOptions(new OptionsValidator(){

            public boolean isInvalid(CommandLineOption option) {
                String optionType = option.getOptionType();
                return !"repo".equalsIgnoreCase(optionType) && !"conf".equalsIgnoreCase(optionType);
            }
        });
        if (invalidOptionsList.size() > 0 || args.length > 4) {
            SampleAxis2Server.printUsage();
            return null;
        }
        Map optionsMap = optionsParser.getAllOptions();
        CommandLineOption repoOption = (CommandLineOption)optionsMap.get("repo");
        CommandLineOption confOption = (CommandLineOption)optionsMap.get("conf");
        log.info((Object)"[SimpleAxisServer] Starting");
        if (repoOption != null) {
            repoLocation = repoOption.getOptionValue();
            System.out.println("[SimpleAxisServer] Using the Axis2 Repository : " + new File(repoLocation).getAbsolutePath());
        }
        if (confOption != null) {
            confLocation = confOption.getOptionValue();
            System.out.println("[SimpleAxisServer] Using the Axis2 Configuration File : " + new File(confLocation).getAbsolutePath());
        }
        try {
            ConfigurationContext configctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoLocation, (String)confLocation);
            SampleAxis2Server.configurePort(configctx);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(configctx);
            listenerManager.start();
            log.info((Object)"[SimpleAxisServer] Started");
            return listenerManager;
        }
        catch (Throwable t) {
            log.fatal((Object)"[SimpleAxisServer] Shutting down. Error starting SimpleAxisServer", t);
            return null;
        }
    }

    private static void configurePort(ConfigurationContext configCtx) {
        TransportInDescription httpsTrsIn;
        TransportInDescription trsIn = (TransportInDescription)configCtx.getAxisConfiguration().getTransportsIn().get("http");
        if (trsIn != null) {
            String port = System.getProperty("http_port");
            if (port != null) {
                try {
                    new Integer(port);
                    trsIn.getParameter("port").setValue((Object)port);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Given port is not a valid integer. Using 9000 for port.");
                    trsIn.getParameter("port").setValue((Object)"9000");
                }
            } else {
                trsIn.getParameter("port").setValue((Object)"9000");
            }
        }
        if ((httpsTrsIn = (TransportInDescription)configCtx.getAxisConfiguration().getTransportsIn().get("https")) != null) {
            String port = System.getProperty("https_port");
            if (port != null) {
                try {
                    new Integer(port);
                    httpsTrsIn.getParameter("port").setValue((Object)port);
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Given port is not a valid integer. Using 9000 for port.");
                    httpsTrsIn.getParameter("port").setValue((Object)"9002");
                }
            } else {
                httpsTrsIn.getParameter("port").setValue((Object)"9002");
            }
        }
    }

    public static void printUsage() {
        System.out.println("Usage: SampleAxisServer -repo <repository>  -conf <axis2 configuration file>");
        System.out.println();
        System.exit(1);
    }
}

