/*
 * Decompiled with CFR 0.152.
 */
package samples.common;

import java.util.List;
import java.util.Random;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;

public class StockQuoteHandler {
    private static final Random RANDOM = new Random();

    public static OMElement createCustomQuoteRequest(String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples/xsd", "m0");
        OMElement chkPrice = factory.createOMElement("CheckPriceRequest", ns);
        OMElement code = factory.createOMElement("Code", ns);
        chkPrice.addChild((OMNode)code);
        code.setText(symbol);
        return chkPrice;
    }

    public static OMElement createStandardQuoteRequest(String symbol, int itrCount) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples/xsd", "m0");
        OMElement getQuote = factory.createOMElement("getQuote", ns);
        for (int i = 0; i < itrCount; ++i) {
            OMElement request = factory.createOMElement("request", ns);
            OMElement symb = factory.createOMElement("symbol", ns);
            request.addChild((OMNode)symb);
            getQuote.addChild((OMNode)request);
            symb.setText(symbol);
        }
        return getQuote;
    }

    public static OMElement createFullQuoteRequest(String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples/xsd", "m0");
        OMElement getQuote = factory.createOMElement("getFullQuote", ns);
        OMElement request = factory.createOMElement("request", ns);
        OMElement symb = factory.createOMElement("symbol", ns);
        request.addChild((OMNode)symb);
        getQuote.addChild((OMNode)request);
        symb.setText(symbol);
        return getQuote;
    }

    public static OMElement createMarketActivityRequest() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples/xsd", "m0");
        OMElement getQuote = factory.createOMElement("getMarketActivity", ns);
        OMElement request = factory.createOMElement("request", ns);
        OMElement symb = null;
        for (int i = 0; i < 100; ++i) {
            symb = factory.createOMElement("symbols", ns);
            symb.setText(StockQuoteHandler.randomString(3));
            request.addChild((OMNode)symb);
        }
        getQuote.addChild((OMNode)request);
        return getQuote;
    }

    public static OMElement createPlaceOrderRequest(double purchPrice, int qty, String symbol) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace ns = factory.createOMNamespace("http://services.samples/xsd", "m0");
        OMElement placeOrder = factory.createOMElement("placeOrder", ns);
        OMElement order = factory.createOMElement("order", ns);
        OMElement price = factory.createOMElement("price", ns);
        OMElement quantity = factory.createOMElement("quantity", ns);
        OMElement symb = factory.createOMElement("symbol", ns);
        price.setText(Double.toString(purchPrice));
        quantity.setText(Integer.toString(qty));
        symb.setText(symbol);
        order.addChild((OMNode)price);
        order.addChild((OMNode)quantity);
        order.addChild((OMNode)symb);
        placeOrder.addChild((OMNode)order);
        return placeOrder;
    }

    public static String parseStandardQuoteResponse(OMElement result) throws Exception {
        AXIOMXPath xPath = new AXIOMXPath("//ns:last");
        xPath.addNamespace("ns", "http://services.samples/xsd");
        OMElement last = (OMElement)xPath.selectSingleNode((Object)result);
        if (last != null) {
            return last.getText();
        }
        throw new Exception("Unexpected response : " + result);
    }

    public static String parseFullQuoteResponse(OMElement result) throws Exception {
        AXIOMXPath xPath = new AXIOMXPath("//ns:last");
        xPath.addNamespace("ns", "http://services.samples/xsd");
        List lastNodes = xPath.selectNodes((Object)result);
        if (lastNodes == null) {
            throw new Exception("Unexpected response : " + result);
        }
        double total = 0.0;
        int count = 0;
        for (OMElement last : lastNodes) {
            total += Double.parseDouble(last.getText());
            ++count;
        }
        return Double.toString(total / (double)count);
    }

    public static String parseMarketActivityResponse(OMElement result) throws Exception {
        AXIOMXPath xPath = new AXIOMXPath("//ns:last");
        xPath.addNamespace("ns", "http://services.samples/xsd");
        List lastNodes = xPath.selectNodes((Object)result);
        if (lastNodes == null) {
            throw new Exception("Unexpected response : " + result);
        }
        double total = 0.0;
        int count = 0;
        for (OMElement last : lastNodes) {
            total += Double.parseDouble(last.getText());
            ++count;
        }
        return Double.toString(total / (double)count);
    }

    public static String parseCustomQuoteResponse(OMElement result) throws Exception {
        AXIOMXPath xPath = new AXIOMXPath("//ns:Price");
        xPath.addNamespace("ns", "http://services.samples/xsd");
        OMElement price = (OMElement)xPath.selectSingleNode((Object)result);
        if (price != null) {
            return price.getText();
        }
        throw new Exception("Unexpected response : " + result);
    }

    public static String randomString(int count) {
        int end = 91;
        int start = 65;
        StringBuffer buffer = new StringBuffer();
        int gap = end - start;
        while (count-- != 0) {
            char ch = (char)(RANDOM.nextInt(gap) + start);
            if (Character.isLetter(ch)) {
                buffer.append(ch);
                continue;
            }
            ++count;
        }
        return buffer.toString();
    }
}

