/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.net.URL;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.synapse.util.UUIDGenerator;
import samples.common.StockQuoteHandler;

public class StockQuoteClient {
    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) {
        String symbol = StockQuoteClient.getProperty("symbol", "IBM");
        String mode = StockQuoteClient.getProperty("mode", "quote");
        String addUrl = StockQuoteClient.getProperty("addurl", null);
        String trpUrl = StockQuoteClient.getProperty("trpurl", null);
        String prxUrl = StockQuoteClient.getProperty("prxurl", null);
        String repo = StockQuoteClient.getProperty("repository", "client_repo");
        String svcPolicy = StockQuoteClient.getProperty("policy", null);
        String rest = StockQuoteClient.getProperty("rest", null);
        String wsrm = StockQuoteClient.getProperty("wsrm", null);
        double price = 0.0;
        int quantity = 0;
        ConfigurationContext configContext = null;
        try {
            Options options = new Options();
            OMElement payload = null;
            ServiceClient serviceClient = null;
            if (repo != null && !"null".equals(repo)) {
                configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repo, (String)(repo + File.separator + "conf" + File.separator + "axis2.xml"));
                serviceClient = new ServiceClient(configContext, null);
            } else {
                serviceClient = new ServiceClient();
            }
            if ("customquote".equals(mode)) {
                payload = StockQuoteHandler.createCustomQuoteRequest(symbol);
                options.setAction("urn:getQuote");
            } else if ("fullquote".equals(mode)) {
                payload = StockQuoteHandler.createFullQuoteRequest(symbol);
                options.setAction("urn:getFullQuote");
            } else if ("placeorder".equals(mode)) {
                price = StockQuoteClient.getRandom(100.0, 0.9, true);
                quantity = (int)StockQuoteClient.getRandom(10000.0, 1.0, true);
                payload = StockQuoteHandler.createPlaceOrderRequest(price, quantity, symbol);
                options.setAction("urn:placeOrder");
            } else if ("marketactivity".equals(mode)) {
                payload = StockQuoteHandler.createMarketActivityRequest();
                options.setAction("urn:getMarketActivity");
            } else if ("quote".equals(mode)) {
                payload = StockQuoteHandler.createStandardQuoteRequest(symbol);
                options.setAction("urn:getQuote");
            }
            if (addUrl != null && !"null".equals(addUrl)) {
                serviceClient.engageModule("addressing");
                options.setTo(new EndpointReference(addUrl));
            }
            if (trpUrl != null && !"null".equals(trpUrl)) {
                options.setProperty("TransportURL", (Object)trpUrl);
            }
            if (prxUrl != null && !"null".equals(prxUrl)) {
                HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
                URL url = new URL(prxUrl);
                proxyProperties.setProxyName(url.getHost());
                proxyProperties.setProxyPort(url.getPort());
                proxyProperties.setUserName("");
                proxyProperties.setPassWord("");
                proxyProperties.setDomain("");
                options.setProperty("PROXY", (Object)proxyProperties);
            }
            if (svcPolicy != null && !"null".equals(svcPolicy) && svcPolicy.length() > 0) {
                System.out.println("Using WS-Security");
                serviceClient.engageModule("addressing");
                serviceClient.engageModule("rampart");
                options.setProperty("rampartPolicy", (Object)StockQuoteClient.loadPolicy(svcPolicy));
            }
            if (Boolean.parseBoolean(rest)) {
                System.out.println("Sending as REST");
                options.setProperty("enableREST", (Object)"true");
            }
            if (Boolean.parseBoolean(wsrm)) {
                System.out.println("Using WS-RM");
                serviceClient.engageModule("sandesha2");
                options.setProperty("Sandesha2LastMessage", (Object)"true");
                options.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, (Object)UUIDGenerator.getUUID());
            }
            serviceClient.setOptions(options);
            if ("placeorder".equals(mode)) {
                serviceClient.fireAndForget(payload);
                Thread.sleep(5000L);
                System.out.println("Order placed for " + quantity + " shares of stock " + symbol + " at a price of $ " + price);
            } else {
                OMElement result = serviceClient.sendReceive(payload);
                if (Boolean.parseBoolean(wsrm)) {
                    Thread.sleep(5000L);
                }
                if ("customquote".equals(mode)) {
                    System.out.println("Custom :: Stock price = $" + StockQuoteHandler.parseCustomQuoteResponse(result));
                } else if ("quote".equals(mode)) {
                    System.out.println("Standard :: Stock price = $" + StockQuoteHandler.parseStandardQuoteResponse(result));
                } else if ("fullquote".equals(mode)) {
                    System.out.println("Full :: Average price = $" + StockQuoteHandler.parseFullQuoteResponse(result));
                } else if ("marketactivity".equals(mode)) {
                    System.out.println("Activity :: Average price = $" + StockQuoteHandler.parseMarketActivityResponse(result));
                }
                if (Boolean.parseBoolean(wsrm)) {
                    configContext.getListenerManager().stop();
                    serviceClient.cleanup();
                    System.exit(0);
                }
            }
            try {
                configContext.terminate();
            }
            catch (Exception ignore) {}
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Policy loadPolicy(String xmlPath) throws Exception {
        StAXOMBuilder builder = new StAXOMBuilder(xmlPath);
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }
}

