/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.nhttp;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;

public class LoggingNHttpClientHandler
implements NHttpClientHandler {
    private final Log log;
    private final NHttpClientHandler handler;

    public LoggingNHttpClientHandler(NHttpClientHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("HTTP client handler may not be null");
        }
        this.handler = handler;
        this.log = LogFactory.getLog(handler.getClass());
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Connected (" + attachment + ")"));
        }
        this.handler.connected(conn, attachment);
    }

    public void closed(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Closed"));
        }
        this.handler.closed(conn);
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        this.log.error((Object)("HTTP connection " + conn + ": " + ex.getMessage()), (Throwable)ex);
        this.handler.exception(conn, ex);
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        this.log.error((Object)("HTTP connection " + conn + ": " + ex.getMessage()), (Throwable)ex);
        this.handler.exception(conn, ex);
    }

    public void requestReady(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Request ready"));
        }
        this.handler.requestReady(conn);
    }

    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Output ready"));
        }
        this.handler.outputReady(conn, encoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content encoder " + encoder));
        }
    }

    public void responseReceived(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            HttpResponse response = conn.getHttpResponse();
            this.log.debug((Object)("HTTP connection " + conn + ": " + response.getStatusLine()));
        }
        this.handler.responseReceived(conn);
    }

    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Input ready"));
        }
        this.handler.inputReady(conn, decoder);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Content decoder " + decoder));
        }
    }

    public void timeout(NHttpClientConnection conn) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("HTTP connection " + conn + ": Timeout"));
        }
        this.handler.timeout(conn);
    }
}

