/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest.handler;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.struts2.rest.handler.ContentTypeHandler;

public class JsonLibHandler
implements ContentTypeHandler {
    public void toObject(Reader in, Object target) throws IOException {
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[1024];
        int len = 0;
        while ((len = in.read(buffer)) > 0) {
            sb.append(buffer, 0, len);
        }
        if (target != null && sb.length() > 0 && sb.charAt(0) == '[') {
            JSONArray jsonArray = JSONArray.fromObject((Object)sb.toString());
            if (target.getClass().isArray()) {
                JSONArray.toArray((JSONArray)jsonArray, (Object)target, (JsonConfig)new JsonConfig());
            } else {
                JSONArray.toList((JSONArray)jsonArray, (Object)target, (JsonConfig)new JsonConfig());
            }
        } else {
            JSONObject jsonObject = JSONObject.fromObject((Object)sb.toString());
            JSONObject.toBean((JSONObject)jsonObject, (Object)target, (JsonConfig)new JsonConfig());
        }
    }

    public String fromObject(Object obj, String resultCode, Writer stream) throws IOException {
        if (obj != null) {
            if (this.isArray(obj)) {
                JSONArray jsonArray = JSONArray.fromObject((Object)obj);
                stream.write(jsonArray.toString());
            } else {
                JSONObject jsonObject = JSONObject.fromObject((Object)obj);
                stream.write(jsonObject.toString());
            }
        }
        return null;
    }

    private boolean isArray(Object obj) {
        return obj instanceof Collection || obj.getClass().isArray();
    }

    public String getContentType() {
        return "text/javascript";
    }

    public String getExtension() {
        return "json";
    }
}

