/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.rest;

import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.struts2.rest.ContentTypeHandlerManager;

public class RestActionInvocation
extends DefaultActionInvocation {
    private static final long serialVersionUID = 3485701178946428716L;
    private static final Logger LOG = LoggerFactory.getLogger(RestActionInvocation.class);
    private ContentTypeHandlerManager handlerSelector;

    protected RestActionInvocation(Map extraContext, boolean pushAction) {
        super(extraContext, pushAction);
    }

    @Inject
    public void setMimeTypeHandlerSelector(ContentTypeHandlerManager sel) {
        this.handlerSelector = sel;
    }

    protected String invokeAction(Object action, ActionConfig actionConfig) throws Exception {
        String methodName = this.proxy.getMethod();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Executing action method = " + actionConfig.getMethodName(), new String[0]);
        }
        String timerKey = "invokeAction: " + this.proxy.getActionName();
        try {
            Method method;
            Object methodResult;
            boolean methodCalled;
            block18: {
                UtilTimerStack.push((String)timerKey);
                methodCalled = false;
                methodResult = null;
                method = null;
                try {
                    method = this.getAction().getClass().getMethod(methodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    try {
                        String altMethodName = "do" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                        method = this.getAction().getClass().getMethod(altMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e1) {
                        if (this.unknownHandler != null) {
                            try {
                                methodResult = this.unknownHandler.handleUnknownActionMethod(action, methodName);
                                methodCalled = true;
                                break block18;
                            }
                            catch (NoSuchMethodException e2) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                }
            }
            if (!methodCalled) {
                methodResult = method.invoke(action, new Object[0]);
            }
            String string = this.processResult(actionConfig, methodResult);
            return string;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The " + methodName + "() is not defined in action " + this.getAction().getClass() + "");
        }
        catch (InvocationTargetException e) {
            String result;
            Throwable t = e.getTargetException();
            if (this.actionEventListener != null && (result = this.actionEventListener.handleException(t, this.getStack())) != null) {
                String string = result;
                return string;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw e;
        }
        finally {
            UtilTimerStack.pop((String)timerKey);
        }
    }

    protected String processResult(ActionConfig actionConfig, Object methodResult) throws IOException {
        if (methodResult instanceof Result) {
            this.explicitResult = (Result)methodResult;
            return null;
        }
        if (methodResult != null) {
            this.resultCode = this.handlerSelector.handleResult(actionConfig, methodResult, this.action);
        }
        return this.resultCode;
    }
}

