/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.moreover;

import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.stax.OutputFactoryImpl;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Lists;
import com.moreover.api.Article;
import com.moreover.api.ArticlesResponse;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import org.apache.streams.core.StreamsDatum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreoverResult
implements Iterable<StreamsDatum> {
    private static final Logger logger = LoggerFactory.getLogger(MoreoverResult.class);
    private ObjectMapper mapper;
    private XmlMapper xmlMapper;
    private String xmlString;
    private String jsonString;
    private ArticlesResponse resultObject;
    private ArticlesResponse.Articles articles;
    private List<Article> articleArray;
    private long start;
    private long end;
    private String clientId;
    private BigInteger maxSequencedId = BigInteger.ZERO;
    protected ArticlesResponse response;
    protected List<StreamsDatum> list = Lists.newArrayList();

    protected MoreoverResult(String clientId, String xmlString, long start, long end) {
        this.xmlString = xmlString;
        this.clientId = clientId;
        this.start = start;
        this.end = end;
        XmlFactory f = new XmlFactory((XMLInputFactory)new InputFactoryImpl(), (XMLOutputFactory)new OutputFactoryImpl());
        JacksonXmlModule module = new JacksonXmlModule();
        module.setDefaultUseWrapper(false);
        this.xmlMapper = new XmlMapper(f, module);
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, Boolean.TRUE.booleanValue());
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY, Boolean.TRUE.booleanValue());
        this.mapper.configure(DeserializationFeature.READ_ENUMS_USING_TO_STRING, Boolean.TRUE.booleanValue());
    }

    public String getClientId() {
        return this.clientId;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public BigInteger process() {
        try {
            this.resultObject = (ArticlesResponse)this.xmlMapper.readValue(this.xmlString, ArticlesResponse.class);
        }
        catch (JsonMappingException e) {
            this.resultObject = (ArticlesResponse)((JsonMappingException.Reference)e.getPath().get(0)).getFrom();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.warn("Unable to process document:");
            logger.warn(this.xmlString);
        }
        if (this.resultObject.getStatus().equals("FAILURE")) {
            logger.warn(this.resultObject.getStatus());
            logger.warn(this.resultObject.getMessageCode());
            logger.warn(this.resultObject.getUserMessage());
            logger.warn(this.resultObject.getDeveloperMessage());
        } else {
            this.articles = this.resultObject.getArticles();
            this.articleArray = this.articles.getArticle();
            for (Article article : this.articleArray) {
                BigInteger sequenceid = new BigInteger(article.getSequenceId());
                this.list.add(new StreamsDatum((Object)article, sequenceid));
                logger.trace("Prior max sequence Id {} current candidate {}", (Object)this.maxSequencedId, (Object)sequenceid);
                if (sequenceid.compareTo(this.maxSequencedId) <= 0) continue;
                this.maxSequencedId = sequenceid;
            }
        }
        return this.maxSequencedId;
    }

    public String getXmlString() {
        return this.xmlString;
    }

    public BigInteger getMaxSequencedId() {
        return this.maxSequencedId;
    }

    @Override
    public Iterator<StreamsDatum> iterator() {
        return this.list.iterator();
    }

    protected static class JsonStringIterator
    implements Iterator<Serializable> {
        private Iterator<Serializable> underlying;

        protected JsonStringIterator(Iterator<Serializable> underlying) {
            this.underlying = underlying;
        }

        @Override
        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        @Override
        public String next() {
            return this.underlying.next().toString();
        }

        @Override
        public void remove() {
            this.underlying.remove();
        }
    }
}

