/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.moreover;

import com.google.common.collect.ImmutableSet;
import java.util.Queue;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.data.moreover.MoreoverClient;
import org.apache.streams.data.moreover.MoreoverResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreoverProviderTask
implements Runnable {
    public static final int LATENCY = 10;
    public static final int REQUIRED_LATENCY = 10000;
    private static Logger logger = LoggerFactory.getLogger(MoreoverProviderTask.class);
    private String lastSequence;
    private final String apiKey;
    private final String apiId;
    private final Queue<StreamsDatum> results;
    private final MoreoverClient moClient;
    private boolean started = false;

    public MoreoverProviderTask(String apiId, String apiKey, Queue<StreamsDatum> results, String lastSequence) {
        this.apiId = apiId;
        this.apiKey = apiKey;
        this.results = results;
        this.lastSequence = lastSequence;
        this.moClient = new MoreoverClient(this.apiId, this.apiKey, this.lastSequence);
        this.initializeClient(this.moClient);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    this.ensureTime(this.moClient);
                    MoreoverResult result = this.moClient.getArticlesAfter(this.lastSequence, 500);
                    this.started = true;
                    this.lastSequence = result.process().toString();
                    for (StreamsDatum entry : ImmutableSet.copyOf(result.iterator())) {
                        this.results.offer(entry);
                    }
                    logger.info("ApiKey={}\tlastSequenceid={}", (Object)this.apiKey, (Object)this.lastSequence);
                }
            }
            catch (Exception e) {
                logger.error("Exception while polling moreover", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void ensureTime(MoreoverClient moClient) {
        try {
            long gap = System.currentTimeMillis() - moClient.pullTime;
            if (gap < 10000L) {
                Thread.sleep(10000L - gap);
            }
        }
        catch (Exception e) {
            logger.warn("Error sleeping for latency");
        }
    }

    private void initializeClient(MoreoverClient moClient) {
        try {
            moClient.getArticlesAfter(this.lastSequence, 2);
        }
        catch (Exception e) {
            logger.error("Failed to start stream, {}", (Object)this.apiKey);
            logger.error("Exception : ", (Throwable)e);
            throw new IllegalStateException("Unable to initialize stream", e);
        }
    }
}

