/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.moreover;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProvider;
import org.apache.streams.core.StreamsResultSet;
import org.apache.streams.data.moreover.MoreoverProviderTask;
import org.apache.streams.moreover.MoreoverConfiguration;
import org.apache.streams.moreover.MoreoverKeyData;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreoverProvider
implements StreamsProvider {
    public static final String STREAMS_ID = "MoreoverProvider";
    private static final Logger LOGGER = LoggerFactory.getLogger(MoreoverProvider.class);
    protected volatile Queue<StreamsDatum> providerQueue = new ConcurrentLinkedQueue<StreamsDatum>();
    private List<MoreoverKeyData> keys;
    private MoreoverConfiguration config;
    private ExecutorService executor;

    public MoreoverProvider(MoreoverConfiguration moreoverConfiguration) {
        this.config = moreoverConfiguration;
        this.keys = Lists.newArrayList();
        for (MoreoverKeyData apiKey : this.config.getApiKeys()) {
            this.keys.add(apiKey);
        }
    }

    public void startStream() {
        for (MoreoverKeyData key : this.keys) {
            MoreoverProviderTask task = new MoreoverProviderTask(key.getId(), key.getKey(), this.providerQueue, key.getStartingSequence());
            this.executor.submit(new Thread(task));
            LOGGER.info("Started producer for {}", (Object)key.getKey());
        }
    }

    public synchronized StreamsResultSet readCurrent() {
        LOGGER.debug("readCurrent: {}", (Object)this.providerQueue.size());
        ArrayList currentIterator = Lists.newArrayList();
        Iterators.addAll((Collection)currentIterator, this.providerQueue.iterator());
        StreamsResultSet current = new StreamsResultSet((Queue)Queues.newConcurrentLinkedQueue((Iterable)currentIterator));
        this.providerQueue.clear();
        return current;
    }

    public StreamsResultSet readNew(BigInteger sequence) {
        return null;
    }

    public StreamsResultSet readRange(DateTime start, DateTime end) {
        return null;
    }

    public boolean isRunning() {
        return !this.executor.isShutdown() && !this.executor.isTerminated();
    }

    public void prepare(Object configurationObject) {
        LOGGER.debug("Prepare");
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void cleanUp() {
    }
}

