/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.data.moreover;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.ArrayList;
import org.apache.streams.moreover.MoreoverConfiguration;
import org.apache.streams.moreover.MoreoverKeyData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreoverConfigurator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoreoverConfigurator.class);

    public static MoreoverConfiguration detectConfiguration(Config moreover) {
        MoreoverConfiguration moreoverConfiguration = new MoreoverConfiguration();
        ArrayList apiKeys = Lists.newArrayList();
        Config apiKeysConfig = moreover.getConfig("apiKeys");
        if (!apiKeysConfig.isEmpty()) {
            for (String apiKeyId : apiKeysConfig.root().keySet()) {
                Config apiKeyConfig = apiKeysConfig.getConfig(apiKeyId);
                apiKeys.add(new MoreoverKeyData().withId(apiKeyConfig.getString("key")).withKey(apiKeyConfig.getString("key")).withStartingSequence(apiKeyConfig.getString("startingSequence")));
            }
        }
        moreoverConfiguration.setApiKeys(apiKeys);
        return moreoverConfiguration;
    }
}

