/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streams.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.streams.core.StreamsDatum;
import org.apache.streams.core.StreamsProcessor;
import org.apache.streams.jackson.StreamsJacksonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathExtractor
implements StreamsProcessor {
    private static final String STREAMS_ID = "JsonPathExtractor";
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonPathExtractor.class);
    private ObjectMapper mapper = new StreamsJacksonMapper();
    private String pathExpression;
    private JsonPath jsonPath;

    public JsonPathExtractor() {
        LOGGER.info("creating JsonPathExtractor");
    }

    public JsonPathExtractor(String pathExpression) {
        this.pathExpression = pathExpression;
        LOGGER.info("creating JsonPathExtractor for " + this.pathExpression);
    }

    public List<StreamsDatum> process(StreamsDatum entry) {
        ArrayList result;
        block15: {
            result = Lists.newArrayList();
            String json = null;
            LOGGER.debug("{} processing {}", (Object)STREAMS_ID);
            if (entry.getDocument() instanceof ObjectNode) {
                ObjectNode node = (ObjectNode)entry.getDocument();
                try {
                    json = this.mapper.writeValueAsString((Object)node);
                }
                catch (JsonProcessingException e) {
                    LOGGER.warn(e.getMessage());
                }
            } else if (entry.getDocument() instanceof String) {
                json = (String)entry.getDocument();
            }
            if (StringUtils.isNotEmpty(json)) {
                try {
                    Object readResult = this.jsonPath.read(json);
                    if (readResult instanceof String) {
                        String match = (String)readResult;
                        LOGGER.info("Matched String: " + match);
                        StreamsDatum matchDatum = new StreamsDatum((Object)match);
                        result.add(matchDatum);
                        break block15;
                    }
                    if (readResult instanceof JSONObject) {
                        JSONObject match = (JSONObject)readResult;
                        LOGGER.info("Matched Object: " + match);
                        ObjectNode objectNode = (ObjectNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)match), ObjectNode.class);
                        StreamsDatum matchDatum = new StreamsDatum((Object)objectNode);
                        result.add(matchDatum);
                        break block15;
                    }
                    if (readResult instanceof JSONArray) {
                        LOGGER.info("Matched Array:");
                        JSONArray array = (JSONArray)readResult;
                        for (Object item : array) {
                            String match;
                            if (item instanceof String) {
                                LOGGER.info("String Item:" + item);
                                match = (String)item;
                                StreamsDatum matchDatum = new StreamsDatum((Object)match);
                                result.add(matchDatum);
                                continue;
                            }
                            if (item instanceof JSONObject) {
                                LOGGER.info("Object Item:" + item);
                                match = (JSONObject)item;
                                ObjectNode objectNode = (ObjectNode)this.mapper.readValue(this.mapper.writeValueAsString((Object)match), ObjectNode.class);
                                StreamsDatum matchDatum = new StreamsDatum((Object)objectNode);
                                result.add(matchDatum);
                                continue;
                            }
                            LOGGER.info("Other Item:" + item.toString());
                        }
                        break block15;
                    }
                    LOGGER.info("Other Match:" + readResult.toString());
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage());
                }
            } else {
                LOGGER.warn("result empty");
            }
        }
        return result;
    }

    public void prepare(Object configurationObject) {
        if (configurationObject instanceof String) {
            this.jsonPath = JsonPath.compile((String)((String)configurationObject), (Filter[])new Filter[0]);
        } else if (configurationObject instanceof String[]) {
            this.jsonPath = JsonPath.compile((String)((String[])configurationObject)[0], (Filter[])new Filter[0]);
        }
        this.mapper.registerModule((Module)new JsonOrgModule());
    }

    public void cleanUp() {
        LOGGER.info("shutting down JsonPathExtractor for " + this.pathExpression);
    }
}

