/*
 * Decompiled with CFR 0.152.
 */
package com.gplus.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.streams.data.ActivitySerializer;
import org.apache.streams.gnip.powertrack.GnipActivityFixer;
import org.apache.streams.pojo.extensions.ExtensionUtil;
import org.apache.streams.pojo.json.Activity;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPlusActivitySerializer
implements ActivitySerializer<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GPlusActivitySerializer.class);

    public String serializationFormat() {
        return "application/gplus+xml";
    }

    public String serialize(Activity deserialized) {
        ObjectMapper jsonMapper = new ObjectMapper();
        String jsonString = new String();
        try {
            jsonString = jsonMapper.writeValueAsString((Object)deserialized);
        }
        catch (Exception e) {
            LOGGER.error("Exception serializing Activity Object: " + e);
        }
        return jsonString;
    }

    public Activity deserialize(String serialized) {
        ObjectMapper jsonMapper = new ObjectMapper();
        JSONObject jsonObject = new JSONObject();
        JSONObject fixedObject = new JSONObject();
        try {
            jsonObject = new JSONObject(serialized);
            fixedObject = GnipActivityFixer.fix((JSONObject)jsonObject);
        }
        catch (Exception e) {
            LOGGER.error("Exception deserializing string: " + e);
        }
        Activity activity = new Activity();
        try {
            activity = (Activity)jsonMapper.readValue(fixedObject.toString(), Activity.class);
            Map extension = ExtensionUtil.ensureExtensions((Activity)activity);
            extension.put("likes", fixedObject.getJSONObject("object").getJSONObject("plusoners").get("totalItems"));
            extension.put("rebroadcast", fixedObject.getJSONObject("object").getJSONObject("resharers").get("totalItems"));
        }
        catch (Exception e) {
            LOGGER.error(jsonObject.toString());
            LOGGER.error(fixedObject.toString());
            e.printStackTrace();
        }
        return activity;
    }

    public List<Activity> deserializeAll(List<String> serializedList) {
        throw new NotImplementedException("Not currently supported by this deserializer");
    }
}

