/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.activation.DataHandler;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.commons.stub.filedownload.FileDownloadServiceStub;
import org.wso2.carbon.core.util.MIMEType2FileExtensionMap;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

public class FileDownloadUtil {
    private static Log log = LogFactory.getLog(FileDownloadUtil.class);
    private MIMEType2FileExtensionMap mimeMap = new MIMEType2FileExtensionMap();

    public FileDownloadUtil(BundleContext context) {
        this.mimeMap.init(context);
    }

    public synchronized boolean acquireResource(ConfigurationContextService configCtxService, HttpServletRequest request, HttpServletResponse response) throws CarbonException {
        ServletOutputStream out;
        try {
            out = response.getOutputStream();
        }
        catch (IOException e) {
            String msg = "Unable to retrieve file ";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
        String fileID = request.getParameter("id");
        String fileName = this.getFileName(configCtxService, request, fileID);
        if (fileName == null) {
            String serverURL = CarbonUIUtil.getServerURL(request.getSession().getServletContext(), request.getSession());
            String serviceEPR = serverURL + "FileDownloadService";
            try {
                FileDownloadServiceStub stub = CarbonUtils.isRunningOnLocalTransportMode() ? new FileDownloadServiceStub(configCtxService.getServerConfigContext(), serviceEPR) : new FileDownloadServiceStub(configCtxService.getClientConfigContext(), serviceEPR);
                DataHandler dataHandler = stub.downloadFile(fileID);
                if (dataHandler != null) {
                    int nextChar;
                    response.setHeader("Content-Disposition", "filename=" + fileID);
                    response.setContentType(dataHandler.getContentType());
                    InputStream in = dataHandler.getDataSource().getInputStream();
                    while ((nextChar = in.read()) != -1) {
                        out.write((char)nextChar);
                    }
                    out.flush();
                    out.close();
                    in.close();
                    return true;
                }
                out.write("The requested file was not found on the server".getBytes());
                out.flush();
                out.close();
            }
            catch (IOException e) {
                String msg = "Unable to write output to HttpServletResponse OutputStream ";
                log.error((Object)msg, (Throwable)e);
                throw new CarbonException(msg, (Throwable)e);
            }
            return false;
        }
        try {
            File file = new File(fileName);
            FileInputStream in = new FileInputStream(file);
            byte[] b = new byte[(int)file.length()];
            response.setContentType(this.mimeMap.getMIMEType(file));
            response.setContentLength((int)file.length());
            response.setHeader("Content-Disposition", "filename=" + file.getName());
            int lengthRead = in.read(b);
            if (lengthRead != -1) {
                out.write(b);
            }
            out.flush();
            out.close();
            in.close();
            return true;
        }
        catch (IOException e) {
            String msg = "Unable to retrieve file ";
            log.error((Object)msg, (Throwable)e);
            throw new CarbonException(msg, (Throwable)e);
        }
    }

    private String getFileName(ConfigurationContextService configCtxService, HttpServletRequest request, String fileID) {
        Map fileResourcesMap = (Map)configCtxService.getClientConfigContext().getProperty("file.resource.map");
        String fileName = (String)fileResourcesMap.get(fileID);
        if (fileName == null) {
            String requestURI = request.getRequestURI();
            ConfigurationContext configContext = configCtxService.getServerConfigContext();
            fileResourcesMap = (Map)configContext.getProperty("file.resource.map");
            fileName = (String)fileResourcesMap.get(fileID);
        }
        return fileName;
    }
}

