/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.common.AuthenticationException;
import org.wso2.carbon.ui.CarbonSSOSessionManager;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.CarbonUIUtil;
import org.wso2.carbon.ui.tracker.AuthenticatorRegistry;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public final class CarbonUILoginUtil {
    private static Log log = LogFactory.getLog(CarbonUILoginUtil.class);
    private static Pattern tenantEnabledUriPattern = Pattern.compile("(/.*/|/)t/[^/]*($|/.*)");
    private static final String TENANT_ENABLED_URI_PATTERN = "(/.*/|/)t/[^/]*($|/.*)";
    protected static final int RETURN_FALSE = 0;
    protected static final int RETURN_TRUE = 1;
    protected static final int CONTINUE = 2;

    protected static Pattern getTenantEnabledUriPattern() {
        return tenantEnabledUriPattern;
    }

    protected static CarbonUIAuthenticator getAuthenticator(HttpServletRequest request) {
        return AuthenticatorRegistry.getCarbonAuthenticator(request);
    }

    protected static boolean saveOriginalUrl(CarbonUIAuthenticator authenticator, HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean skipLoginPage, String contextPath, String indexPageURL, String requestedURI) throws IOException {
        if (!requestedURI.endsWith("admin/error.jsp")) {
            String queryString = request.getQueryString();
            String tmpURI = queryString != null ? requestedURI + "?" + queryString : requestedURI;
            tmpURI = "../.." + tmpURI;
            request.getSession(false).setAttribute("requestedUri", (Object)tmpURI);
            if (!tmpURI.contains("session-validate.jsp") && !"/null".equals(requestedURI)) {
                Cookie cookie = new Cookie("requestedURI", tmpURI);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
        }
        try {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equals("wso2.carbon.rememberme") || authenticator == null) continue;
                    try {
                        authenticator.authenticateWithCookie(request);
                        return true;
                    }
                    catch (AuthenticationException ignored) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)ignored);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"error occurred while login", (Throwable)e);
        }
        if (request.getAttribute("tenantDomain") != null) {
            if (skipLoginPage) {
                response.sendRedirect("../admin/login_action.jsp");
            } else {
                response.sendRedirect("../admin/login.jsp");
            }
        } else if (skipLoginPage) {
            response.sendRedirect(contextPath + "/carbon/admin/login_action.jsp");
        } else {
            response.sendRedirect(contextPath + "/carbon/admin/login.jsp");
        }
        return false;
    }

    protected static String getCustomIndexPage(HttpServletRequest request, String indexPageURL) {
        if (request.getParameter("IndexPageURL") != null) {
            return request.getParameter("IndexPageURL");
        }
        if (indexPageURL == null) {
            return "/carbon/admin/index.jsp";
        }
        return indexPageURL;
    }

    protected static String getIndexPageUrlFromCookie(String requestedURI, String indexPageURL, HttpServletRequest request) {
        Cookie[] cookies;
        if (requestedURI.equals("/carbon/admin/login_action.jsp") && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("requestedURI")) continue;
                indexPageURL = cookie.getValue();
            }
            if (tenantEnabledUriPattern.matcher(indexPageURL).matches()) {
                indexPageURL = CarbonUIUtil.removeTenantSpecificStringsFromURL(indexPageURL);
            }
        }
        return indexPageURL;
    }

    protected static boolean letRequestedUrlIn(String requestedURI, String tempUrl) {
        return requestedURI.endsWith(".css") || requestedURI.endsWith(".gif") || requestedURI.endsWith(".GIF") || requestedURI.endsWith(".jpg") || requestedURI.endsWith(".JPG") || requestedURI.endsWith(".png") || requestedURI.endsWith(".PNG") || requestedURI.endsWith(".xsl") || requestedURI.endsWith(".xslt") || requestedURI.endsWith(".js") || requestedURI.startsWith("/registry") || requestedURI.endsWith(".html") || requestedURI.endsWith(".ico") || requestedURI.startsWith("/openid/") || requestedURI.indexOf("/openid/") > -1 || requestedURI.indexOf("/openidserver") > -1 || requestedURI.indexOf("/gadgets") > -1 || requestedURI.indexOf("/samlsso") > -1;
    }

    protected static boolean handleLogout(CarbonUIAuthenticator authenticator, HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean authenticated, String contextPath, String indexPageURL, String httpLogin) throws IOException {
        log.debug((Object)"Handling Logout..");
        try {
            authenticator = (CarbonUIAuthenticator)session.getAttribute("CarbonAuthenticator");
            if (authenticator != null) {
                authenticator.unauthenticate(request);
                log.debug((Object)"Backend session invalidated");
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            response.sendRedirect("../admin/login.jsp");
            return false;
        }
        if ("true".equals(request.getParameter("logoutcomplete"))) {
            HttpSession currentSession = request.getSession(false);
            if (currentSession != null) {
                session.removeAttribute("logged-user");
                session.getServletContext().removeAttribute("logged-user");
                try {
                    session.invalidate();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                log.debug((Object)"Frontend session invalidated");
            }
            response.sendRedirect("../../carbon/admin/login.jsp");
            return false;
        }
        if (request.getAttribute("ExternalLogoutPage") != null) {
            HttpSession currentSession = request.getSession(false);
            if (currentSession != null) {
                session.removeAttribute("logged-user");
                session.getServletContext().removeAttribute("logged-user");
                try {
                    session.invalidate();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                log.debug((Object)"Frontend session invalidated");
            }
            response.sendRedirect((String)request.getAttribute("ExternalLogoutPage"));
            return false;
        }
        CarbonSSOSessionManager ssoSessionManager = CarbonSSOSessionManager.getInstance();
        if (!ssoSessionManager.skipSSOSessionInvalidation(request, authenticator) && !ssoSessionManager.isSessionValid(request.getSession().getId())) {
            block19: {
                HttpSession currentSession = request.getSession(false);
                if (currentSession != null) {
                    session.removeAttribute("logged-user");
                    session.getServletContext().removeAttribute("logged-user");
                    try {
                        session.invalidate();
                        log.debug((Object)"SSO session session invalidated ");
                    }
                    catch (Exception ignored) {
                        if (!log.isDebugEnabled()) break block19;
                        log.debug((Object)"Ignore exception when invalidating session", (Throwable)ignored);
                    }
                }
            }
            response.sendRedirect("../.." + indexPageURL);
            return false;
        }
        ssoSessionManager.removeInvalidSession(request.getSession().getId());
        if (request.getAttribute("logoutRequest") != null) {
            log.debug((Object)"Loging out from SSO session");
            response.sendRedirect("../../carbon/sso-acs/redirect_ajaxprocessor.jsp?logout=true");
            return false;
        }
        HttpSession currentSession = request.getSession(false);
        if (currentSession != null) {
            session.removeAttribute("logged-user");
            session.getServletContext().removeAttribute("logged-user");
            try {
                session.invalidate();
                log.debug((Object)"Frontend session invalidated");
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        Cookie rmeCookie = new Cookie("wso2.carbon.rememberme", null);
        rmeCookie.setPath("/");
        rmeCookie.setSecure(true);
        rmeCookie.setMaxAge(0);
        response.addCookie(rmeCookie);
        response.sendRedirect(contextPath + indexPageURL);
        return false;
    }

    protected static boolean handleLogin(CarbonUIAuthenticator authenticator, HttpServletRequest request, HttpServletResponse response, HttpSession session, boolean authenticated, String contextPath, String indexPageURL, String httpLogin) throws IOException {
        try {
            authenticator.authenticate(request);
            session = request.getSession();
            session.setAttribute("CarbonAuthenticator", (Object)authenticator);
            String userName = (String)request.getAttribute("username");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Login request from " + userName));
            }
            String tenantDomain = null;
            if (request.getAttribute("tenantDomain") != null) {
                tenantDomain = (String)request.getAttribute("tenantDomain");
            }
            if (tenantDomain == null) {
                tenantDomain = MultitenantUtils.getTenantDomain((String)userName);
            }
            if (tenantDomain != null && !"carbon.super".equals(tenantDomain)) {
                contextPath = contextPath + "/t/" + tenantDomain;
            }
            String value = request.getParameter("rememberMe");
            boolean isRememberMe = false;
            if (value != null && value.equals("rememberMe")) {
                isRememberMe = true;
            }
            try {
                if (isRememberMe) {
                    String rememberMeCookieValue = (String)request.getAttribute("wso2.carbon.rememberme.value");
                    int age = Integer.parseInt((String)request.getAttribute("wso2.carbon.rememberme.age"));
                    Cookie rmeCookie = new Cookie("wso2.carbon.rememberme", rememberMeCookieValue);
                    rmeCookie.setPath("/");
                    rmeCookie.setSecure(true);
                    rmeCookie.setMaxAge(age);
                    response.addCookie(rmeCookie);
                }
            }
            catch (Exception e) {
                response.sendRedirect(contextPath + indexPageURL + (indexPageURL.indexOf(63) == -1 ? "?" : "&") + "loginStatus=false");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Security check failed for login request for " + userName));
                }
                return false;
            }
            if (contextPath != null) {
                if (indexPageURL.startsWith("../..")) {
                    indexPageURL = indexPageURL.substring(5);
                }
                response.sendRedirect(contextPath + indexPageURL + (indexPageURL.indexOf(63) == -1 ? "?" : "&") + "loginStatus=true");
            }
        }
        catch (AuthenticationException e) {
            log.debug((Object)"Authentication failure ...", (Throwable)e);
            try {
                request.getSession().invalidate();
                CarbonUILoginUtil.getAuthenticator(request).unauthenticate(request);
                if (httpLogin != null) {
                    response.sendRedirect(httpLogin + "?loginStatus=false");
                    return false;
                }
                response.sendRedirect("/carbon/admin/login.jsp?loginStatus=false");
                return false;
            }
            catch (Exception e1) {
            }
        }
        catch (Exception e) {
            log.error((Object)"error occurred while login", (Throwable)e);
            response.sendRedirect("../../carbon/admin/login.jsp?loginStatus=failed");
        }
        return false;
    }

    protected static String getForcedSignOutRequestedURI(String requestedURI, HttpServletRequest request) {
        if (requestedURI.endsWith(".jsp") && !requestedURI.endsWith("ajaxprocessor.jsp") && !requestedURI.endsWith("session_validate.jsp") && request.getSession().getAttribute("authenticated") != null && ((Boolean)request.getSession().getAttribute("authenticated")).booleanValue() && (request.getSession().getAttribute("tenantDomain") == null && request.getAttribute("tenantDomain") != null || request.getSession().getAttribute("tenantDomain") != null && request.getAttribute("tenantDomain") != null && !request.getSession().getAttribute("tenantDomain").equals(request.getAttribute("tenantDomain")))) {
            requestedURI = "../admin/logout_action.jsp";
        }
        return requestedURI;
    }

    protected static int handleLoginPageRequest(String requestedURI, HttpServletRequest request, HttpServletResponse response, boolean authenticated, String context, String indexPageURL) throws IOException {
        if (requestedURI.indexOf("login.jsp") > -1 || requestedURI.indexOf("login_ajaxprocessor.jsp") > -1 || requestedURI.indexOf("admin/layout/template.jsp") > -1 || requestedURI.endsWith("/filedownload") || requestedURI.endsWith("/fileupload") || requestedURI.indexOf("/fileupload/") > -1 || requestedURI.indexOf("login_action.jsp") > -1 || requestedURI.indexOf("admin/jsp/WSRequestXSSproxy_ajaxprocessor.jsp") > -1) {
            if ((requestedURI.indexOf("login.jsp") > -1 || requestedURI.indexOf("login_ajaxprocessor.jsp") > -1 || requestedURI.indexOf("login_action.jsp") > -1) && authenticated) {
                String tenantDomain;
                if (request.getSession().getAttribute("tenantDomain") != null && (tenantDomain = (String)request.getSession().getAttribute("tenantDomain")) != null && !"carbon.super".equals(tenantDomain)) {
                    context = context + "/t/" + tenantDomain;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User already authenticated. Redirecting to " + indexPageURL));
                }
                response.sendRedirect(context + "/carbon/admin/index.jsp");
                return 0;
            }
            if (requestedURI.indexOf("login_action.jsp") > -1 && !authenticated) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"User is not yet authenticated and now trying to get authenticated;do nothing, leave for authentication at the end");
                }
                return 2;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping security checks for " + requestedURI));
            }
            return 1;
        }
        return 2;
    }

    protected static boolean escapeTenantWebAppRequests(boolean authenticated, HttpServletResponse response, String requestedURI, String context) throws IOException {
        if (requestedURI.contains("/webapps/")) {
            response.sendError(404, "Web application not found. Request URI: " + requestedURI);
            return false;
        }
        if (requestedURI.contains("/carbon/admin/login.jsp") && !authenticated) {
            response.sendRedirect(context + "/carbon/admin/login.jsp");
            log.debug((Object)"Redirecting to /carbon/admin/login.jsp");
            return false;
        }
        log.debug((Object)"Skipping security checks");
        return true;
    }

    protected static String addNewContext(String requestedURI) {
        String tmp1;
        int end;
        String tmp = requestedURI;
        String customWarContext = "";
        if (requestedURI.startsWith("/carbon") && !requestedURI.startsWith("/carbon/carbon/")) {
            requestedURI = tmp;
        } else if (requestedURI.indexOf("filedownload") == -1 && requestedURI.indexOf("fileupload") == -1 && (end = (tmp1 = tmp.replaceFirst("/", "")).indexOf(47)) > -1) {
            customWarContext = tmp1.substring(0, end);
            requestedURI = !requestedURI.startsWith("/registry/registry/") && !requestedURI.startsWith("/registry/carbon/") && (customWarContext.equals("registry") || customWarContext.equals("gadgets") || customWarContext.equals("social")) ? tmp : tmp.substring(end + 1);
        }
        return requestedURI;
    }
}

