/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.ui.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.config.CloudServiceConfig;
import org.apache.stratos.common.config.CloudServiceConfigParser;
import org.apache.stratos.common.config.CloudServicesDescConfig;
import org.apache.stratos.tenant.activity.stub.beans.xsd.PaginatedTenantDataBean;
import org.apache.stratos.tenant.activity.stub.beans.xsd.TenantDataBean;
import org.apache.stratos.tenant.activity.ui.utils.ManagerConfigurations;

public class TenantMonitorUtil {
    private static final Log log = LogFactory.getLog(TenantMonitorUtil.class);
    public static Map<String, String[]> tenantList = new HashMap<String, String[]>();
    public static Map<String, TenantDataBean[]> tenantDataList = new HashMap<String, TenantDataBean[]>();
    private static ManagerConfigurations managerConfig = null;

    public static ManagerConfigurations getManagerConfig() {
        return managerConfig;
    }

    public static void setManagerConfig(ManagerConfigurations managerConfig) {
        TenantMonitorUtil.managerConfig = managerConfig;
    }

    public static Map<String, CloudServiceConfig> getCloudServiceConfigMap() {
        try {
            CloudServicesDescConfig cloudServicesDescConfig = CloudServiceConfigParser.loadCloudServicesConfiguration();
            return cloudServicesDescConfig.getCloudServiceConfigs();
        }
        catch (Exception e) {
            log.error((Object)("Error while getting service names " + e.toString()));
            return null;
        }
    }

    public static PaginatedTenantDataBean getPaginatedTenantData(int pageNumber, String serviceName) {
        int entriesPerPage = 15;
        List<Object> tenantListOnService = Arrays.asList((Object[])tenantDataList.get(serviceName));
        ArrayList<TenantDataBean> tenantUsages = new ArrayList<TenantDataBean>();
        int i = 0;
        int numberOfPages = 0;
        for (TenantDataBean tenantDataBean : tenantListOnService) {
            if (i % entriesPerPage == 0) {
                ++numberOfPages;
            }
            if (numberOfPages == pageNumber) {
                tenantUsages.add(tenantDataBean);
            }
            ++i;
        }
        PaginatedTenantDataBean paginatedTenantInfo = new PaginatedTenantDataBean();
        paginatedTenantInfo.setTenantInfoBeans(tenantUsages.toArray(new TenantDataBean[tenantUsages.size()]));
        paginatedTenantInfo.setNumberOfPages(numberOfPages);
        return paginatedTenantInfo;
    }

    public static boolean isTenantActiveOnService(String serviceName, String domain) {
        boolean status = false;
        for (TenantDataBean tenantBean : tenantDataList.get(serviceName)) {
            if (!tenantBean.getDomain().equalsIgnoreCase(domain)) continue;
            status = true;
        }
        return status;
    }

    public static Map<String, String> getAdminParameters() {
        HashMap<String, String> adminParameters = new HashMap<String, String>();
        if (managerConfig == null) {
            try {
                managerConfig = new ManagerConfigurations();
            }
            catch (Exception e) {
                log.error((Object)("Failed to get administrator credentials" + e.toString()));
            }
        }
        adminParameters.put("userName", managerConfig.getUserName());
        adminParameters.put("password", managerConfig.getPassword());
        return adminParameters;
    }
}

