/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.activity.ui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommonUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class ManagerConfigurations {
    private static final String CONFIG_FILE = "throttling-agent-config.xml";
    private static final String MANAGER_SERVICE_URL_PARAM_NAME = "managerServiceUrl";
    private static final String USERNAME_PARAM_NAME = "userName";
    private static final String PASSWORD_PARAM_NAME = "password";
    private String managerServerUrl;
    private String userName;
    private String password;
    private static final Log log = LogFactory.getLog(ManagerConfigurations.class);
    private static final String CONFIG_NS = "http://wso2.com/stratos/multitenancy/throttling/agent/config";
    private static final String PARAMTERS_ELEMENT_NAME = "parameters";
    private static final String PARAMTER_ELEMENT_NAME = "parameter";
    private static final String PARAMTER_NAME_ATTR_NAME = "name";
    private Map<String, String> parameters = new HashMap<String, String>();

    public String getConfigFileName() throws Exception {
        String configFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "multitenancy" + File.separator + CONFIG_FILE;
        return configFileName;
    }

    public ManagerConfigurations() throws Exception {
        String throttlingAgentConfigFile = this.getConfigFileName();
        try {
            OMElement meteringConfig = CommonUtil.buildOMElement((InputStream)new FileInputStream(throttlingAgentConfigFile));
            this.deSerialize(meteringConfig);
            Map<String, String> throttlingAgentParams = this.getParameters();
            this.setUserName(throttlingAgentParams.get(USERNAME_PARAM_NAME));
            this.setPassword(throttlingAgentParams.get(PASSWORD_PARAM_NAME));
            this.setManagerServerUrl(throttlingAgentParams.get(MANAGER_SERVICE_URL_PARAM_NAME));
        }
        catch (FileNotFoundException e) {
            String msg = "Unable to find the file: " + throttlingAgentConfigFile + ".";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void deSerialize(OMElement throttlingConfigEle) throws Exception {
        Iterator meteringConfigChildIt = throttlingConfigEle.getChildElements();
        while (meteringConfigChildIt.hasNext()) {
            OMElement meteringConfigChildEle;
            Object meteringConfigChild = meteringConfigChildIt.next();
            if (!(meteringConfigChild instanceof OMElement) || !new QName(CONFIG_NS, PARAMTERS_ELEMENT_NAME, "").equals((meteringConfigChildEle = (OMElement)meteringConfigChild).getQName())) continue;
            Iterator parametersChildIt = meteringConfigChildEle.getChildElements();
            while (parametersChildIt.hasNext()) {
                OMElement parameterChildEle;
                Object taskConfigChild = parametersChildIt.next();
                if (!(taskConfigChild instanceof OMElement) || !new QName(CONFIG_NS, PARAMTER_ELEMENT_NAME, "").equals((parameterChildEle = (OMElement)taskConfigChild).getQName())) continue;
                String parameterName = parameterChildEle.getAttributeValue(new QName(PARAMTER_NAME_ATTR_NAME));
                String parameterValue = parameterChildEle.getText();
                this.parameters.put(parameterName, parameterValue);
            }
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getManagerServerUrl() {
        return this.managerServerUrl;
    }

    public void setManagerServerUrl(String managerServerUrl) {
        this.managerServerUrl = managerServerUrl;
    }
}

