/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util.converters;

import com.paypal.sdk.util.XMLSerializer;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.SerializationMethodInvoker;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PPConverter
implements Converter {
    private final Mapper mapper;
    private final ReflectionProvider reflectionProvider;
    private final SerializationMethodInvoker serializationMethodInvoker;

    public PPConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        this.serializationMethodInvoker = new SerializationMethodInvoker();
    }

    public boolean canConvert(Class type) {
        return true;
    }

    public void marshal(Object original, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source.getClass() != original.getClass()) {
            writer.addAttribute(this.mapper.attributeForReadResolveField(), this.mapper.serializedClass(source.getClass()));
        }
        final HashSet seenFields = new HashSet();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (fieldName.indexOf("hashCodeCalc") != -1 || fieldName.indexOf("equalsCalc") != -1) {
                    return;
                }
                if (newObj == null && !Modifier.isStatic(fieldType.getModifiers()) && !definedIn.getName().equals("com.paypal.soap.api.AbstractRequestType")) {
                    newObj = XMLSerializer.inflate(fieldType);
                }
                if (newObj != null) {
                    Mapper.ImplicitCollectionMapping mapping = PPConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), fieldName);
                    if (mapping != null) {
                        if (mapping.getItemFieldName() != null) {
                            ArrayList list = (ArrayList)newObj;
                            for (Object obj : list) {
                                this.writeField(mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(fieldName, fieldType, definedIn, newObj);
                        seenFields.add(fieldName);
                    }
                }
            }

            private void writeField(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (!PPConverter.this.mapper.shouldSerializeMember(definedIn, fieldName)) {
                    return;
                }
                writer.startNode(PPConverter.this.mapper.serializedMember(definedIn, fieldName));
                Class<?> actualType = newObj.getClass();
                Class defaultType = PPConverter.this.mapper.defaultImplementationOf(fieldType);
                if (!actualType.equals(defaultType)) {
                    writer.addAttribute(PPConverter.this.mapper.attributeForImplementationClass(), PPConverter.this.mapper.serializedClass(actualType));
                }
                if (seenFields.contains(fieldName)) {
                    writer.addAttribute(PPConverter.this.mapper.attributeForClassDefiningField(), PPConverter.this.mapper.serializedClass(definedIn));
                }
                context.convertAnother(newObj);
                writer.endNode();
            }
        });
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(context, reader.getAttribute(this.mapper.attributeForReadResolveField()));
        SeenFields seenFields = new SeenFields();
        Map implicitCollectionsForCurrentObject = null;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String fieldName = this.mapper.realMember(result.getClass(), reader.getNodeName());
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = this.reflectionProvider.fieldDefinedInClass(fieldName, result.getClass());
            Class type = this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField);
            Object value = context.convertAnother(result, type);
            if (fieldExistsInClass) {
                this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                seenFields.add(classDefiningField, fieldName);
            } else {
                implicitCollectionsForCurrentObject = this.writeValueToImplicitCollection(context, value, implicitCollectionsForCurrentObject, result, fieldName);
            }
            reader.moveUp();
        }
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    private Map writeValueToImplicitCollection(UnmarshallingContext context, Object value, Map implicitCollections, Object result, String itemFieldName) {
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value.getClass(), itemFieldName);
        if (fieldName != null) {
            ArrayList<Object> collection;
            if (implicitCollections == null) {
                implicitCollections = new HashMap<String, ArrayList<Object>>();
            }
            if ((collection = (ArrayList<Object>)implicitCollections.get(fieldName)) == null) {
                collection = new ArrayList<Object>();
                this.reflectionProvider.writeField(result, fieldName, collection, null);
                implicitCollections.put(fieldName, collection);
            }
            collection.add(value);
        }
        return implicitCollections;
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String definedIn = reader.getAttribute(this.mapper.attributeForClassDefiningField());
        return definedIn == null ? null : this.mapper.realClass(definedIn);
    }

    private Object instantiateNewInstance(UnmarshallingContext context, String readResolveValue) {
        Object currentObject = context.currentObject();
        if (currentObject != null) {
            return currentObject;
        }
        if (readResolveValue != null) {
            return this.reflectionProvider.newInstance(this.mapper.realClass(readResolveValue));
        }
        return this.reflectionProvider.newInstance(context.getRequiredType());
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = reader.getAttribute(this.mapper.attributeForImplementationClass());
        if (classAttribute != null) {
            return this.mapper.realClass(classAttribute);
        }
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            return this.mapper.realClass(reader.getNodeName());
        }
        return this.mapper.defaultImplementationOf(this.reflectionProvider.getFieldType(result, fieldName, definedInCls));
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            String uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException(uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }
}

