/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.util.MessageResources;
import com.paypal.sdk.util.converters.CalendarConverter;
import com.paypal.sdk.util.converters.PPConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;

public abstract class XMLSerializer {
    private static XStream ppSerializer;
    private static XStream serializer;

    private static void initSerializer() {
        serializer = new XStream();
        serializer.registerConverter((Converter)new CalendarConverter());
    }

    private static void initPPSerializer() {
        ppSerializer = new XStream();
        PPConverter converter = new PPConverter((Mapper)ppSerializer.getClassMapper(), new JVM().bestReflectionProvider());
        ppSerializer.registerConverter((Converter)converter, -1);
        ppSerializer.registerConverter((Converter)new CalendarConverter());
    }

    public static String toXMLTemplate(Object object) {
        if (ppSerializer == null) {
            XMLSerializer.initPPSerializer();
        }
        return ppSerializer.toXML(object);
    }

    public static String toXML(Object object) throws PayPalException {
        try {
            if (serializer == null) {
                XMLSerializer.initSerializer();
            }
            return serializer.toXML(object);
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("SERIALIZE_ERROR"), e.getMessage()), e);
        }
    }

    public static Object fromXML(String xml) throws PayPalException {
        try {
            if (serializer == null) {
                XMLSerializer.initSerializer();
            }
            return serializer.fromXML(xml);
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("DESERIALIZE_ERROR"), e.getMessage()), e);
        }
    }

    public static Object inflate(Class type) {
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return Boolean.FALSE;
        }
        if (type.equals(Byte.TYPE) || type.equals(Byte.class)) {
            return new Byte("0");
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return new Integer(0);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return new Long(0L);
        }
        if (type.equals(BigInteger.class)) {
            return BigInteger.ZERO;
        }
        if (type.equals(Calendar.class)) {
            return Calendar.getInstance();
        }
        if (type.isArray()) {
            Object array = Array.newInstance(type.getComponentType(), 1);
            Array.set(array, 0, XMLSerializer.inflate(type.getComponentType()));
            return array;
        }
        try {
            if (type.getDeclaredField("_value_") != null) {
                Field[] fields = type.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    if (!fields[i].getType().equals(type)) continue;
                    return fields[i].get(null);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            Object obj = type.newInstance();
            return obj;
        }
        catch (Exception e) {
            return null;
        }
    }
}

