/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.util;

import com.paypal.sdk.exceptions.FatalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.util.MessageResources;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PPCrypto {
    private static Log log = LogFactory.getLog(PPCrypto.class);

    public static KeyStore p12ToKeyStore(String p12Path, String password) throws FatalException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("PPCrypto.p12ToKeyStore, keystore = " + p12Path));
        }
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance("PKCS12", "SunJSSE");
        }
        catch (KeyStoreException e) {
            throw new FatalException(MessageResources.getMessage("JKS_ERROR"), e);
        }
        catch (NoSuchProviderException e) {
            throw new FatalException(MessageResources.getMessage("JKS_ERROR"), e);
        }
        try {
            FileInputStream in = new FileInputStream(p12Path);
            ks.load(in, password.toCharArray());
        }
        catch (FileNotFoundException e) {
            throw new FatalException(MessageFormat.format(MessageResources.getMessage("PAYPAL_CERT_ERROR"), p12Path), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FatalException(MessageResources.getMessage("JKS_ALGORITHM_ERROR"), e);
        }
        catch (CertificateException e) {
            throw new FatalException(MessageResources.getMessage("CERT_DECODE_ERROR"), e);
        }
        catch (IOException e) {
            throw new FatalException(MessageFormat.format(MessageResources.getMessage("PAYPAL_CERT_ERROR"), p12Path), e);
        }
        return ks;
    }

    public static String[] readPayPalCertFile(String filename) throws IOException {
        StringBuffer key;
        StringBuffer cert = new StringBuffer();
        StringBuffer toWrite = key = new StringBuffer();
        BufferedReader read = new BufferedReader(new FileReader(filename));
        String line = read.readLine();
        while (line != null) {
            if (line.equals("")) {
                line = read.readLine();
                continue;
            }
            if (line.startsWith("-----BEGIN CERTIFICATE")) {
                toWrite = cert;
            }
            if (!"-----BEGIN RSA PRIVATE KEY-----".equals(line) && !"-----END RSA PRIVATE KEY-----".equals(line)) {
                toWrite.append(line + "\n");
            }
            line = read.readLine();
        }
        return new String[]{cert.toString(), key.toString()};
    }

    public static X509Certificate getUserCertFromString(String certPEM) throws TransactionException {
        X509Certificate client_cert;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certPEM.getBytes());
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            client_cert = (X509Certificate)cf.generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new TransactionException("Could not create an X509Certificate from input PEM string", e);
        }
        return client_cert;
    }
}

