/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.services;

import com.paypal.sdk.core.soap.SOAPAPICaller;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.util.MessageResources;
import com.paypal.sdk.util.XMLSerializer;
import com.paypal.soap.api.AbstractRequestType;
import com.paypal.soap.api.AbstractResponseType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;

public class CallerServices {
    private SOAPAPICaller caller = new SOAPAPICaller();

    public String getWSDLVersion() throws PayPalException {
        return this.caller.getAPIVersion();
    }

    public Collection getAvailableOperations() throws PayPalException {
        return this.caller.getAvailableOperations();
    }

    public String getRequestTemplate(String operationName) throws PayPalException {
        Object object = null;
        Method method = this.caller.getOperation(operationName);
        if (method == null) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("SOAP_OPERATION_ERROR"), operationName));
        }
        try {
            Class<?>[] pars = method.getParameterTypes();
            if (!pars[0].getName().endsWith("Req")) {
                object = pars[0].newInstance();
            } else {
                Field[] fields = pars[0].getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Class<?> type = fields[i].getType();
                    if (!type.getName().endsWith("RequestType")) continue;
                    object = type.newInstance();
                }
            }
        }
        catch (Exception e) {
            throw new TransactionException(MessageFormat.format(MessageResources.getMessage("TEMPLATE_INSTANTIATION_ERROR"), e.getMessage()), e);
        }
        return XMLSerializer.toXMLTemplate(object);
    }

    public void setAPIProfile(APIProfile profile) throws PayPalException {
        this.caller.setupConnection(profile);
    }

    public AbstractResponseType call(String operationName, AbstractRequestType request) throws PayPalException {
        return this.caller.call(operationName, request);
    }

    public String call(String operationName, String requestStr) throws PayPalException {
        AbstractRequestType request = (AbstractRequestType)XMLSerializer.fromXML(requestStr);
        AbstractResponseType response = this.call(operationName, request);
        return XMLSerializer.toXML(response);
    }
}

