/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.profiles;

import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.ProfileHandler;
import com.paypal.sdk.profiles.Profiles;
import com.paypal.sdk.util.MessageResources;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class DefaultProfileHandler
implements ProfileHandler {
    @Override
    public final Profiles retrieve() throws PayPalException {
        try {
            FileInputStream fis = new FileInputStream("profiles");
            ObjectInputStream ois = new ObjectInputStream(fis);
            Profiles profiles = (Profiles)ois.readObject();
            ois.close();
            fis.close();
            return profiles;
        }
        catch (ClassNotFoundException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_RETRIEVE_ERROR"), e);
        }
        catch (NotSerializableException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_RETRIEVE_ERROR"), e);
        }
        catch (IOException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_RETRIEVE_ERROR"), e);
        }
    }

    @Override
    public final void store(Profiles profiles) throws PayPalException {
        try {
            FileOutputStream fos = new FileOutputStream("profiles");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(profiles);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (NotSerializableException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_STORE_ERROR"), e);
        }
        catch (IOException e) {
            throw new WarningException(MessageResources.getMessage("PROFILE_STORE_ERROR"), e);
        }
    }
}

