/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.logging;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultSOAPHandler
extends BasicHandler {
    private static Log log;
    private static Templates templates;
    private static TransformerFactory tFactory;

    public void init() {
    }

    public void cleanup() {
    }

    public void invoke(MessageContext ctx) {
        if (log.isDebugEnabled()) {
            try {
                Message msg = ctx.getCurrentMessage();
                log.debug((Object)this.transform(msg.getSOAPPartAsString()));
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onFault(MessageContext fault) {
        try {
            log.error((Object)("SOAP FAULT: " + fault.getCurrentMessage().getSOAPPartAsString()));
        }
        catch (AxisFault f) {
            log.error((Object)("axis fault: " + f.getMessage()));
        }
    }

    public String transform(String soap) throws TransformerException, IOException {
        Transformer transformer = templates.newTransformer();
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(soap)), new StreamResult(writer));
        return writer.toString();
    }

    static {
        block2: {
            log = LogFactory.getLog(DefaultSOAPHandler.class);
            try {
                ClassLoader cl = DefaultSOAPHandler.class.getClassLoader();
                InputStream is = cl.getResourceAsStream("xsl/soapProtect.xsl");
                tFactory = TransformerFactory.newInstance();
                templates = tFactory.newTemplates(new StreamSource(is));
            }
            catch (TransformerConfigurationException e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }
}

