/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.core;

import com.paypal.sdk.core.EndpointsReader;
import com.paypal.sdk.core.Keys;
import com.paypal.sdk.exceptions.PayPalException;
import com.paypal.sdk.exceptions.TransactionException;
import com.paypal.sdk.exceptions.WarningException;
import com.paypal.sdk.profiles.APIProfile;
import com.paypal.sdk.profiles.CertificateAPIProfile;
import com.paypal.sdk.profiles.PermissionAPIProfile;
import com.paypal.sdk.profiles.SignatureAPIProfile;
import com.paypal.sdk.profiles.UniPayAPIProfile;
import com.paypal.sdk.util.MessageResources;
import com.paypal.sdk.util.PPCrypto;
import com.paypal.sdk.util.Util;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class APICallerBase {
    private static Log log = LogFactory.getLog(APICallerBase.class);
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static Map endpoints;

    public void finalize() {
        Keys.unregisterKeys(String.valueOf(this.hashCode()));
    }

    protected static void setupHandler(String message, DefaultHandler handler) throws SAXException, IOException {
        ClassLoader cl = APICallerBase.class.getClassLoader();
        URL url = cl.getResource(message);
        XMLReader xr = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
        xr.setContentHandler(handler);
        xr.parse(new InputSource(url.openStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readEndpoints(String message) {
        try {
            EndpointsReader handler = new EndpointsReader("65.1");
            APICallerBase.setupHandler(message, handler);
            endpoints = handler.getEndpoints();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)MessageResources.getMessage("READ_ENDPOINTS_ERROR"), (Throwable)e);
            }
        }
        finally {
            if ((endpoints == null || endpoints.isEmpty()) && log.isWarnEnabled()) {
                log.warn((Object)MessageResources.getMessage("ENDPOINTS_EMPTY"));
            }
        }
    }

    private static void readProxyInfo() {
        block10: {
            try {
                String message = "sdkproxy";
                ResourceBundle bundle = ResourceBundle.getBundle(message, Locale.getDefault());
                String useProxy = bundle.getString("PROXY_SET");
                if ("true".equalsIgnoreCase(useProxy)) {
                    String password;
                    String host = bundle.getString("PROXY_HOST");
                    String port = bundle.getString("PROXY_PORT");
                    Integer.parseInt(port);
                    Properties systemProperties = System.getProperties();
                    systemProperties.put("https.proxySet", useProxy);
                    systemProperties.put("https.proxyHost", host);
                    systemProperties.put("https.proxyPort", port);
                    String username = bundle.getString("PROXY_USERNAME");
                    if (!Util.isEmpty(username)) {
                        systemProperties.put("https.proxyUser", username);
                    }
                    if (!Util.isEmpty(password = bundle.getString("PROXY_PASSWORD"))) {
                        systemProperties.put("https.proxyPassword", password);
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)MessageFormat.format(MessageResources.getMessage("PROXY_SET"), host, port));
                    }
                }
            }
            catch (MissingResourceException e) {
                if (log.isInfoEnabled()) {
                    log.info((Object)MessageResources.getMessage("PROXY_NOT_SET"));
                }
            }
            catch (NumberFormatException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)MessageResources.getMessage("PROXY_PORT_INVALID"), (Throwable)e);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)MessageResources.getMessage("PROXY_INVALID"), (Throwable)e);
            }
        }
    }

    protected abstract void validateProfile(APIProfile var1) throws PayPalException;

    public synchronized void setupConnection(APIProfile _profile) throws PayPalException {
        if (_profile == null) {
            throw new WarningException(MessageResources.getMessage("PROFILE_INVALID"));
        }
        this.validateProfile(_profile);
        this.registerKey(_profile);
    }

    protected void registerKey(APIProfile _profile) throws PayPalException {
        KeyStore ks;
        KeyManagerFactory kmf;
        if (Keys.containsKey(String.valueOf(this.hashCode()))) {
            Keys.unregisterKeys(String.valueOf(this.hashCode()));
        }
        if (_profile instanceof CertificateAPIProfile) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                ks = PPCrypto.p12ToKeyStore(_profile.getCertificateFile(), _profile.getPrivateKeyPassword());
                kmf.init(ks, _profile.getPrivateKeyPassword().toCharArray());
                Keys.registerKeys(String.valueOf(this.hashCode()), kmf.getKeyManagers());
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
            catch (KeyStoreException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
            catch (UnrecoverableKeyException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
        }
        if (_profile instanceof PermissionAPIProfile) {
            try {
                if (_profile.getCertificateFile() != null && _profile.getCertificateFile().length() > 0) {
                    kmf = KeyManagerFactory.getInstance("SunX509");
                    ks = PPCrypto.p12ToKeyStore(_profile.getCertificateFile(), _profile.getPrivateKeyPassword());
                    kmf.init(ks, _profile.getPrivateKeyPassword().toCharArray());
                    Keys.registerKeys(String.valueOf(this.hashCode()), kmf.getKeyManagers());
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
            catch (KeyStoreException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
            catch (UnrecoverableKeyException e) {
                throw new TransactionException(MessageResources.getMessage("KEYMANAGERS_ERROR"), e);
            }
        }
    }

    public String getAPIVersion() {
        return "65.1";
    }

    protected String getEndpointUrl(APIProfile _profile, QName name) {
        String endpointName = _profile.getEnvironment().toLowerCase() + "-" + name.getLocalPart().toLowerCase();
        if (_profile instanceof CertificateAPIProfile) {
            return (String)endpoints.get(endpointName);
        }
        if (_profile instanceof UniPayAPIProfile) {
            return (String)endpoints.get(endpointName);
        }
        if (_profile instanceof SignatureAPIProfile) {
            return (String)endpoints.get(endpointName + "-threetoken");
        }
        if (_profile instanceof PermissionAPIProfile) {
            return (String)endpoints.get(endpointName);
        }
        return null;
    }

    static {
        APICallerBase.readProxyInfo();
    }
}

