/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.email.sender.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.beans.TenantInfoBean;
import org.apache.stratos.common.util.ClaimsMgtUtil;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.email.sender.api.EmailSender;
import org.apache.stratos.email.sender.api.EmailSenderConfiguration;
import org.apache.stratos.tenant.mgt.email.sender.internal.DataHolder;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.email.verification.util.EmailVerifierConfig;
import org.wso2.carbon.email.verification.util.Util;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.UUIDGenerator;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.CarbonUtils;

public class TenantMgtEmailSenderUtil {
    private static final Log log = LogFactory.getLog(TenantMgtEmailSenderUtil.class);
    private static EmailSender successMsgSender;
    private static EmailSender tenantCreationNotifier;
    private static EmailSender tenantActivationNotifier;
    private static EmailSender passwordResetMsgSender;
    private static EmailVerifierConfig emailVerifierConfig;
    private static EmailVerifierConfig superTenantEmailVerifierConfig;

    public static void init() {
        TenantMgtEmailSenderUtil.initTenantActivatedEmailSender();
        TenantMgtEmailSenderUtil.initSuperTenantNotificationEmailSender();
        TenantMgtEmailSenderUtil.initEmailVerificationSender();
        TenantMgtEmailSenderUtil.initPasswordResetEmailSender();
    }

    public static void sendTenantCreationVerification(TenantInfoBean tenantInfoBean) throws Exception {
        String confirmationKey = TenantMgtEmailSenderUtil.generateConfirmationKey(tenantInfoBean, DataHolder.getRegistryService().getConfigSystemRegistry(-1234));
        if (CommonUtil.isTenantActivationModerated()) {
            TenantMgtEmailSenderUtil.requestSuperTenantModeration(tenantInfoBean, confirmationKey);
        } else {
            TenantMgtEmailSenderUtil.requestUserVerification(tenantInfoBean, confirmationKey);
        }
    }

    public static void notifyTenantInitialActivation(int tenantId) {
        TenantManager tenantManager = DataHolder.getTenantManager();
        String firstName = "";
        String domainName = "";
        String adminName = "";
        String email = "";
        try {
            Tenant tenant = tenantManager.getTenant(tenantId);
            domainName = tenant.getDomain();
            firstName = ClaimsMgtUtil.getFirstName((RealmService)DataHolder.getRealmService(), (int)tenantId);
            adminName = tenant.getAdminName();
            email = tenant.getEmail();
        }
        catch (Exception e) {
            String msg = "Unable to get the tenant with the tenant domain";
            log.error((Object)msg, (Throwable)e);
        }
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("first-name", firstName);
        userParams.put("user-name", adminName);
        userParams.put("domain-name", domainName);
        try {
            successMsgSender.sendEmail(email, userParams);
        }
        catch (Exception e) {
            String msg = "Error in sending the notification email.";
            log.error((Object)msg, (Throwable)e);
        }
        TenantMgtEmailSenderUtil.notifyTenantActivationToSuperAdmin(domainName, adminName, email);
    }

    public static void notifyTenantCreationToSuperAdmin(TenantInfoBean tenantInfoBean) {
        String notificationEmailAddress = CommonUtil.getNotificationEmailAddress();
        if (notificationEmailAddress.trim().equals("")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No super-admin notification email address is set to notify upon a tenant registration");
            }
            return;
        }
        Map<String, String> userParams = TenantMgtEmailSenderUtil.initializeSuperTenantNotificationParams(tenantInfoBean.getTenantDomain(), tenantInfoBean.getAdmin(), tenantInfoBean.getEmail());
        try {
            tenantCreationNotifier.sendEmail(notificationEmailAddress, userParams);
        }
        catch (Exception e) {
            String msg = "Error in sending the notification email.";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public static void notifyResetPassword(TenantInfoBean tenantInfoBean) throws Exception {
        int tenantId = tenantInfoBean.getTenantId();
        String firstName = ClaimsMgtUtil.getFirstName((RealmService)DataHolder.getRealmService(), (int)tenantId);
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("user-name", tenantInfoBean.getAdmin());
        userParams.put("first-name", firstName);
        userParams.put("domain-name", tenantInfoBean.getTenantDomain());
        userParams.put("password", tenantInfoBean.getAdminPassword());
        try {
            passwordResetMsgSender.sendEmail(tenantInfoBean.getEmail(), userParams);
        }
        catch (Exception e) {
            String msg = "Error in sending the notification email.";
            log.error((Object)msg, (Throwable)e);
        }
    }

    private static void notifyTenantActivationToSuperAdmin(String domainName, String adminName, String email) {
        String notificationEmailAddress = CommonUtil.getNotificationEmailAddress();
        if (notificationEmailAddress.trim().equals("")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No super-admin notification email address is set to notify upon a tenant activation");
            }
            return;
        }
        Map<String, String> userParams = TenantMgtEmailSenderUtil.initializeSuperTenantNotificationParams(domainName, adminName, email);
        try {
            tenantActivationNotifier.sendEmail(notificationEmailAddress, userParams);
        }
        catch (Exception e) {
            String msg = "Error in sending the notification email.";
            log.error((Object)msg, (Throwable)e);
        }
    }

    private static String generateConfirmationKey(TenantInfoBean tenantInfoBean, UserRegistry superTenantConfigSystemRegistry) throws RegistryException {
        Resource resource;
        UserRegistry superTenantGovernanceSystemRegistry;
        String confirmationKey = UUIDGenerator.generateUUID();
        try {
            superTenantGovernanceSystemRegistry = DataHolder.getRegistryService().getGovernanceSystemRegistry(-1234);
        }
        catch (RegistryException e) {
            String msg = "Exception in getting the governance system registry for the super tenant";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        String emailVerificationPath = "/repository/components/org.wso2.carbon.email-confirmation-flag/" + tenantInfoBean.getTenantId();
        try {
            resource = superTenantGovernanceSystemRegistry.resourceExists(emailVerificationPath) ? superTenantGovernanceSystemRegistry.get(emailVerificationPath) : superTenantGovernanceSystemRegistry.newResource();
            resource.setContent((Object)confirmationKey);
        }
        catch (RegistryException e) {
            String msg = "Error in creating the resource or getting the resourcefrom the email verification path";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        resource.addProperty("isEmailValidated", "false");
        resource.addProperty("tenantAdminUsername", tenantInfoBean.getAdmin());
        try {
            superTenantGovernanceSystemRegistry.put(emailVerificationPath, resource);
        }
        catch (RegistryException e) {
            String msg = "Error in putting the resource to the super tenant registry for the email verification path";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        if (tenantInfoBean.getOriginatedService() != null) {
            String originatedServicePath = "/repository/components/org.wso2.carbon.originated-service/originatedService/" + tenantInfoBean.getTenantId();
            try {
                Resource origServiceRes = superTenantConfigSystemRegistry.newResource();
                origServiceRes.setContent((Object)tenantInfoBean.getOriginatedService());
                superTenantGovernanceSystemRegistry.put(originatedServicePath, origServiceRes);
            }
            catch (RegistryException e) {
                String msg = "Error in putting the originated service resource to the governance registry";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
        }
        TenantMgtEmailSenderUtil.initializeRegistry(tenantInfoBean.getTenantId());
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully generated the confirmation key.");
        }
        return confirmationKey;
    }

    private static void requestSuperTenantModeration(TenantInfoBean tenantInfoBean, String confirmationKey) throws Exception {
        try {
            HashMap<String, String> dataToStore = new HashMap<String, String>();
            dataToStore.put("email", CommonUtil.getSuperAdminEmail());
            dataToStore.put("first-name", tenantInfoBean.getFirstname());
            dataToStore.put("userName", tenantInfoBean.getAdmin());
            dataToStore.put("tenantDomain", tenantInfoBean.getTenantDomain());
            dataToStore.put("confirmationKey", confirmationKey);
            DataHolder.getEmailVerificationService().requestUserVerification(dataToStore, superTenantEmailVerifierConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Email verification for the tenant registration.");
            }
        }
        catch (Exception e) {
            String msg = "Error in notifying the super tenant on the account creation for the domain: " + tenantInfoBean.getTenantDomain();
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    private static void requestUserVerification(TenantInfoBean tenantInfoBean, String confirmationKey) throws Exception {
        try {
            HashMap<String, String> dataToStore = new HashMap<String, String>();
            dataToStore.put("email", tenantInfoBean.getEmail());
            dataToStore.put("first-name", tenantInfoBean.getFirstname());
            dataToStore.put("userName", tenantInfoBean.getAdmin());
            dataToStore.put("tenantDomain", tenantInfoBean.getTenantDomain());
            dataToStore.put("confirmationKey", confirmationKey);
            EmailVerifcationSubscriber emailVerifier = DataHolder.getEmailVerificationService();
            emailVerifier.requestUserVerification(dataToStore, emailVerifierConfig);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Email verification for the tenant registration.");
            }
        }
        catch (Exception e) {
            String msg = "Error in notifying tenant of domain: " + tenantInfoBean.getTenantDomain();
            log.error((Object)msg);
            throw new Exception(msg, e);
        }
    }

    private static void initializeRegistry(int tenantId) {
        BundleContext bundleContext = DataHolder.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    private static void initSuperTenantNotificationEmailSender() {
        String tenantRegistrationEmailConfFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-new-tenant-registration.xml";
        EmailSenderConfiguration newTenantRegistrationEmailConf = EmailSenderConfiguration.loadEmailSenderConfiguration((String)tenantRegistrationEmailConfFile);
        tenantCreationNotifier = new EmailSender(newTenantRegistrationEmailConf);
        String tenantActivationEmailConfFile = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-new-tenant-activation.xml";
        EmailSenderConfiguration newTenantActivationEmailConf = EmailSenderConfiguration.loadEmailSenderConfiguration((String)tenantActivationEmailConfFile);
        tenantActivationNotifier = new EmailSender(newTenantActivationEmailConf);
    }

    private static void initEmailVerificationSender() {
        String confXml = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-registration.xml";
        try {
            emailVerifierConfig = Util.loadeMailVerificationConfig((String)confXml);
        }
        catch (Exception e) {
            String msg = "Email Registration Configuration file not found. Pls check the repository/conf/email folder.";
            log.error((Object)msg);
        }
        String superTenantConfXml = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-registration-moderation.xml";
        try {
            superTenantEmailVerifierConfig = Util.loadeMailVerificationConfig((String)superTenantConfXml);
        }
        catch (Exception e) {
            String msg = "Email Moderation Configuration file not found. Pls check the repository/conf/email folder.";
            log.error((Object)msg);
        }
    }

    private static void initTenantActivatedEmailSender() {
        String confFilename = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-registration-complete.xml";
        EmailSenderConfiguration successMsgConfig = EmailSenderConfiguration.loadEmailSenderConfiguration((String)confFilename);
        successMsgSender = new EmailSender(successMsgConfig);
    }

    private static void initPasswordResetEmailSender() {
        String passwordResetConfigFileName = CarbonUtils.getCarbonConfigDirPath() + File.separator + "email" + File.separator + "email-password-reset.xml";
        EmailSenderConfiguration passwordResetMsgConfig = EmailSenderConfiguration.loadEmailSenderConfiguration((String)passwordResetConfigFileName);
        passwordResetMsgSender = new EmailSender(passwordResetMsgConfig);
    }

    private static Map<String, String> initializeSuperTenantNotificationParams(String domainName, String adminName, String email) {
        TenantManager tenantManager = DataHolder.getTenantManager();
        String firstName = "";
        String lastName = "";
        try {
            int tenantId = tenantManager.getTenantId(domainName);
            firstName = ClaimsMgtUtil.getFirstName((RealmService)DataHolder.getRealmService(), (int)tenantId);
            lastName = ClaimsMgtUtil.getLastName((RealmService)DataHolder.getRealmService(), (int)tenantId);
        }
        catch (Exception e) {
            String msg = "Unable to get the tenant with the tenant domain";
            log.error((Object)msg, (Throwable)e);
        }
        HashMap<String, String> userParams = new HashMap<String, String>();
        userParams.put("user-name", adminName);
        userParams.put("domain-name", domainName);
        userParams.put("email-address", email);
        userParams.put("first-name", firstName);
        userParams.put("last-name", lastName);
        return userParams;
    }

    static {
        superTenantEmailVerifierConfig = null;
    }
}

