/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.tenant.mgt.email.sender.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.listeners.TenantMgtListener;
import org.apache.stratos.common.util.CommonUtil;
import org.apache.stratos.tenant.mgt.email.sender.internal.DataHolder;
import org.apache.stratos.tenant.mgt.email.sender.listener.EmailSenderListener;
import org.apache.stratos.tenant.mgt.email.sender.util.TenantMgtEmailSenderUtil;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.email.verification.util.EmailVerifcationSubscriber;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class TenantMgtEmailSenderServiceComponent {
    private static Log log = LogFactory.getLog(TenantMgtEmailSenderServiceComponent.class);

    protected void activate(ComponentContext context) {
        try {
            DataHolder.setBundleContext(context.getBundleContext());
            if (!CommonUtil.isTenantManagementEmailsDisabled()) {
                TenantMgtEmailSenderUtil.init();
                EmailSenderListener emailSenderListener = new EmailSenderListener();
                context.getBundleContext().registerService(TenantMgtListener.class.getName(), (Object)emailSenderListener, null);
                log.debug((Object)"******* Tenant Management Emails are enabled ******* ");
            }
            log.debug((Object)"******* Tenant Registration Email Sender bundle is activated ******* ");
        }
        catch (Throwable e) {
            log.error((Object)"******* Tenant Registration Email Sender bundle failed activating ****", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        log.debug((Object)"******* Email Sender bundle is deactivated ******* ");
    }

    protected void setRegistryService(RegistryService registryService) {
        DataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        DataHolder.setRegistryService(null);
    }

    protected void setRealmService(RealmService realmService) {
        DataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        DataHolder.setRealmService(null);
    }

    protected void setConfigurationContextService(ConfigurationContextService service) {
        DataHolder.setConfigurationContextService(service);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService service) {
        DataHolder.setConfigurationContextService(null);
    }

    protected void setEmailVerificationService(EmailVerifcationSubscriber emailService) {
        DataHolder.setEmailVerificationService(emailService);
    }

    protected void unsetEmailVerificationService(EmailVerifcationSubscriber emailService) {
        DataHolder.setEmailVerificationService(null);
    }
}

